/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.glObject;

import com.seibel.distanthorizons.api.enums.config.EDhApiGLErrorHandlingMode;
import com.seibel.distanthorizons.api.enums.config.EDhApiGpuUploadMethod;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.objects.GLMessage;
import com.seibel.distanthorizons.core.util.objects.GLMessageOutputStream;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLUtil;

public class GLProxy {
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final Logger LOGGER = DhLoggerBuilder.getLogger(MethodHandles.lookup().lookupClass().getSimpleName());
    public static final ConfigBasedLogger GL_LOGGER = new ConfigBasedLogger(LogManager.getLogger(GLProxy.class), () -> Config.Client.Advanced.Logging.logRendererGLEvent.get());
    private static GLProxy instance = null;
    private final ConcurrentLinkedQueue<Runnable> renderThreadRunnableQueue = new ConcurrentLinkedQueue();
    public final GLCapabilities glCapabilities;
    public boolean namedObjectSupported = false;
    public boolean bufferStorageSupported = false;
    public boolean vertexAttributeBufferBindingSupported = false;
    public boolean instancedArraysSupported = false;
    public boolean vertexAttribDivisorSupported = false;
    private final EDhApiGpuUploadMethod preferredUploadMethod;
    public final GLMessage.Builder vanillaDebugMessageBuilder = GLMessage.Builder.DEFAULT_MESSAGE_BUILDER;

    private GLProxy() throws IllegalStateException {
        if (GLFW.glfwGetCurrentContext() == 0L) {
            throw new IllegalStateException(GLProxy.class.getSimpleName() + " was created outside the render thread!");
        }
        GL_LOGGER.info("Creating " + GLProxy.class.getSimpleName() + "... If this is the last message you see there must have been an OpenGL error.", new Object[0]);
        GL_LOGGER.info("Lod Render OpenGL version [" + GL32.glGetString((int)7938) + "].", new Object[0]);
        this.glCapabilities = GL.getCapabilities();
        if (!this.glCapabilities.OpenGL32) {
            String supportedVersionInfo = this.getFailedVersionInfo(this.glCapabilities);
            String errorMessage = "Distant Horizons was initializing " + GLProxy.class.getSimpleName() + " and discovered this GPU doesn't meet the OpenGL requirements. Sorry I couldn't tell you sooner :(\nAdditional info:\n" + supportedVersionInfo;
            MC.crashMinecraft(errorMessage, new UnsupportedOperationException("Distant Horizon OpenGL requirements not met"));
        }
        GL_LOGGER.info("minecraftGlCapabilities:\n" + this.versionInfoToString(this.glCapabilities), new Object[0]);
        if (Config.Client.Advanced.Debugging.OpenGl.overrideVanillaGLLogger.get().booleanValue()) {
            GLUtil.setupDebugMessageCallback((PrintStream)new PrintStream(new GLMessageOutputStream(GLProxy::logMessage, this.vanillaDebugMessageBuilder), true));
        }
        this.namedObjectSupported = this.glCapabilities.glNamedBufferData != 0L;
        boolean bl = this.bufferStorageSupported = this.glCapabilities.glBufferStorage != 0L;
        if (!this.bufferStorageSupported) {
            GL_LOGGER.info("This GPU doesn't support Buffer Storage (OpenGL 4.4), falling back to using other methods.", new Object[0]);
        }
        this.vertexAttributeBufferBindingSupported = this.glCapabilities.glBindVertexBuffer != 0L;
        this.vertexAttribDivisorSupported = this.glCapabilities.OpenGL33;
        this.instancedArraysSupported = this.glCapabilities.GL_ARB_instanced_arrays;
        String vendor = GL32.glGetString((int)7936).toUpperCase();
        this.preferredUploadMethod = vendor.contains("NVIDIA") || vendor.contains("GEFORCE") ? (this.bufferStorageSupported ? EDhApiGpuUploadMethod.BUFFER_STORAGE : EDhApiGpuUploadMethod.SUB_DATA) : (this.bufferStorageSupported ? EDhApiGpuUploadMethod.BUFFER_STORAGE : EDhApiGpuUploadMethod.DATA);
        GL_LOGGER.info("GPU Vendor [" + vendor + "], Preferred upload method is [" + (Object)((Object)this.preferredUploadMethod) + "].", new Object[0]);
        GL_LOGGER.info(GLProxy.class.getSimpleName() + " creation successful. OpenGL smiles upon you this day.", new Object[0]);
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public static GLProxy getInstance() {
        if (instance == null) {
            instance = new GLProxy();
        }
        return instance;
    }

    public EDhApiGpuUploadMethod getGpuUploadMethod() {
        return this.preferredUploadMethod;
    }

    public boolean runningOnRenderThread() {
        long currentContext = GLFW.glfwGetCurrentContext();
        return currentContext != 0L;
    }

    public void queueRunningOnRenderThread(Runnable renderCall) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        this.renderThreadRunnableQueue.add(() -> this.runOpenGlCall(renderCall, stackTrace));
    }

    private void runOpenGlCall(Runnable renderCall, StackTraceElement[] stackTrace) {
        try {
            renderCall.run();
        }
        catch (Exception e) {
            RuntimeException error = new RuntimeException("Uncaught Exception during execution:", e);
            error.setStackTrace(stackTrace);
            GL_LOGGER.error(Thread.currentThread().getName() + " ran into a issue: ", error);
        }
    }

    public void runRenderThreadTasks() {
        long currentTime;
        long runDuration;
        long startTime = System.nanoTime();
        Runnable runnable = this.renderThreadRunnableQueue.poll();
        while (runnable != null && (runDuration = (currentTime = System.nanoTime()) - startTime) <= 4000000L) {
            runnable.run();
            runnable = this.renderThreadRunnableQueue.poll();
        }
    }

    private static void logMessage(GLMessage msg) {
        EDhApiGLErrorHandlingMode errorHandlingMode = Config.Client.Advanced.Debugging.OpenGl.glErrorHandlingMode.get();
        if (errorHandlingMode == EDhApiGLErrorHandlingMode.IGNORE) {
            return;
        }
        if (msg.type == GLMessage.EType.ERROR || msg.type == GLMessage.EType.UNDEFINED_BEHAVIOR) {
            GL_LOGGER.error("GL ERROR " + msg.id + " from " + (Object)((Object)msg.source) + ": " + msg.message, new Object[0]);
            if (errorHandlingMode == EDhApiGLErrorHandlingMode.LOG_THROW) {
                throw new RuntimeException("GL ERROR: " + msg);
            }
        } else {
            GLMessage.ESeverity severity = msg.severity;
            RuntimeException ex = new RuntimeException("GL MESSAGE: " + msg);
            if (severity == null) {
                severity = GLMessage.ESeverity.LOW;
            }
            switch (severity) {
                case HIGH: {
                    GL_LOGGER.error("{}", ex);
                    break;
                }
                case MEDIUM: {
                    GL_LOGGER.warn("{}", ex);
                    break;
                }
                case LOW: {
                    GL_LOGGER.info("{}", ex);
                    break;
                }
                case NOTIFICATION: {
                    GL_LOGGER.debug("{}", ex);
                }
            }
        }
    }

    private String getFailedVersionInfo(GLCapabilities c) {
        return "Your OpenGL support:\nopenGL version 3.2+: [" + c.OpenGL32 + "] <- REQUIRED\nVertex Attribute Buffer Binding: [" + (c.glVertexAttribBinding != 0L) + "] <- optional improvement\nBuffer Storage: [" + (c.glBufferStorage != 0L) + "] <- optional improvement\nIf you noticed that your computer supports higher OpenGL versions but not the required version, try running the game in compatibility mode. (How you turn that on, I have no clue~)";
    }

    private String versionInfoToString(GLCapabilities c) {
        return "Your OpenGL support:\nopenGL version 3.2+: [" + c.OpenGL32 + "] <- REQUIRED\nVertex Attribute Buffer Binding: [" + (c.glVertexAttribBinding != 0L) + "] <- optional improvement\nBuffer Storage: [" + (c.glBufferStorage != 0L) + "] <- optional improvement\n";
    }
}

