/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.level;

import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiRenderParam;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.file.fullDatafile.FullDataSourceProviderV2;
import com.seibel.distanthorizons.core.file.structure.AbstractSaveStructure;
import com.seibel.distanthorizons.core.level.AbstractDhLevel;
import com.seibel.distanthorizons.core.level.ClientLevelModule;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.level.IDhServerLevel;
import com.seibel.distanthorizons.core.level.ServerLevelModule;
import com.seibel.distanthorizons.core.level.WorldGenModule;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.logging.f3.F3Screen;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.render.RenderBufferHandler;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericObjectRenderer;
import com.seibel.distanthorizons.core.sql.repo.FullDataSourceV2Repo;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.awt.Color;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.Logger;

public class DhClientServerLevel
extends AbstractDhLevel
implements IDhClientLevel,
IDhServerLevel {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    public final ServerLevelModule serverside;
    public final ClientLevelModule clientside;
    private final IServerLevelWrapper serverLevelWrapper;

    public DhClientServerLevel(AbstractSaveStructure saveStructure, IServerLevelWrapper serverLevelWrapper) {
        if (saveStructure.getFullDataFolder(serverLevelWrapper).mkdirs()) {
            LOGGER.warn("unable to create data folder.");
        }
        this.serverLevelWrapper = serverLevelWrapper;
        this.serverLevelWrapper.setParentLevel(this);
        this.serverside = new ServerLevelModule(this, saveStructure);
        this.clientside = new ClientLevelModule(this);
        this.createAndSetSupportingRepos(((FullDataSourceV2Repo)this.serverside.fullDataFileHandler.repo).databaseFile);
        this.runRepoReliantSetup();
        LOGGER.info("Started " + DhClientServerLevel.class.getSimpleName() + " for " + serverLevelWrapper + " with saves at " + saveStructure);
    }

    @Override
    public void clientTick() {
        this.clientside.clientTick();
    }

    @Override
    public void render(DhApiRenderParam renderEventParam, IProfilerWrapper profiler) {
        this.clientside.render(renderEventParam, profiler);
    }

    @Override
    public void renderDeferred(DhApiRenderParam renderEventParam, IProfilerWrapper profiler) {
        this.clientside.renderDeferred(renderEventParam, profiler);
    }

    @Override
    public void serverTick() {
    }

    @Override
    public void doWorldGen() {
        this.serverside.worldGeneratorEnabledConfig.pollNewValue();
        boolean shouldDoWorldGen = this.serverside.worldGeneratorEnabledConfig.get() != false && this.clientside.isRendering();
        boolean isWorldGenRunning = this.serverside.worldGenModule.isWorldGenRunning();
        if (shouldDoWorldGen && !isWorldGenRunning) {
            this.serverside.worldGenModule.startWorldGen(this.serverside.fullDataFileHandler, new ServerLevelModule.WorldGenState(this));
        } else if (!shouldDoWorldGen && isWorldGenRunning) {
            this.serverside.worldGenModule.stopWorldGen(this.serverside.fullDataFileHandler);
        }
        if (isWorldGenRunning) {
            this.serverside.worldGenModule.worldGenTick(new DhBlockPos2D(MC_CLIENT.getPlayerBlockPos()));
        }
    }

    public void startRenderer(IClientLevelWrapper clientLevel) {
        this.clientside.startRenderer(clientLevel);
    }

    public void stopRenderer() {
        this.clientside.stopRenderer();
    }

    @Override
    public int computeBaseColor(DhBlockPos pos, IBiomeWrapper biome, IBlockStateWrapper block) {
        IClientLevelWrapper clientLevel = this.getClientLevelWrapper();
        if (clientLevel == null) {
            return 0;
        }
        return clientLevel.getBlockColor(pos, biome, block);
    }

    @Override
    public IClientLevelWrapper getClientLevelWrapper() {
        return MC_CLIENT.getWrappedClientLevel();
    }

    @Override
    public void clearRenderCache() {
        this.clientside.clearRenderCache();
    }

    @Override
    public IServerLevelWrapper getServerLevelWrapper() {
        return this.serverLevelWrapper;
    }

    @Override
    public ILevelWrapper getLevelWrapper() {
        return this.getServerLevelWrapper();
    }

    @Override
    public FullDataSourceProviderV2 getFullDataProvider() {
        return this.serverside.fullDataFileHandler;
    }

    @Override
    public AbstractSaveStructure getSaveStructure() {
        return this.serverside.saveStructure;
    }

    @Override
    public boolean hasSkyLight() {
        return this.serverLevelWrapper.hasSkyLight();
    }

    @Override
    public CompletableFuture<Void> updateDataSourcesAsync(FullDataSourceV2 data) {
        return this.clientside.updateDataSourcesAsync(data);
    }

    @Override
    public int getMinY() {
        return this.getLevelWrapper().getMinHeight();
    }

    @Override
    public void addDebugMenuStringsToList(List<String> messageList) {
        String dimName = this.serverLevelWrapper.getDimensionType().getDimensionName();
        boolean rendering = this.clientside.isRendering();
        messageList.add("[" + dimName + "] rendering: " + (rendering ? "yes" : "no"));
        boolean migrationErrored = this.serverside.fullDataFileHandler.getMigrationStoppedWithError();
        if (!migrationErrored) {
            long migrationCount;
            long legacyDeletionCount = this.serverside.fullDataFileHandler.getLegacyDeletionCount();
            if (legacyDeletionCount > 0L) {
                messageList.add("  Migrating - Deleting #: " + F3Screen.NUMBER_FORMAT.format(legacyDeletionCount));
            }
            if ((migrationCount = this.serverside.fullDataFileHandler.getTotalMigrationCount()) > 0L) {
                messageList.add("  Migrating - Conversion #: " + F3Screen.NUMBER_FORMAT.format(migrationCount));
            }
        } else {
            messageList.add("  Migration Failed");
        }
        WorldGenModule worldGenState = this.serverside.worldGenModule;
        String worldGenDisplayString = worldGenState.getDebugMenuString();
        if (worldGenDisplayString != null) {
            messageList.add(worldGenDisplayString);
        }
    }

    @Override
    public GenericObjectRenderer getGenericRenderer() {
        return this.clientside.genericRenderer;
    }

    @Override
    public RenderBufferHandler getRenderBufferHandler() {
        ClientLevelModule.ClientRenderState renderState = this.clientside.ClientRenderStateRef.get();
        return renderState != null ? renderState.renderBufferHandler : null;
    }

    @Override
    public void close() {
        this.clientside.close();
        super.close();
        this.serverside.close();
        LOGGER.info("Closed " + this.getClass().getSimpleName() + " for " + this.getServerLevelWrapper());
    }

    @Override
    public void onWorldGenTaskComplete(long pos) {
        DebugRenderer.makeParticle(new DebugRenderer.BoxParticle(new DebugRenderer.Box(pos, 128.0f, 156.0f, 0.09f, Color.red.darker()), 0.2, 32.0f));
        this.clientside.reloadPos(pos);
    }
}

