/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.jar.installer;

import DistantHorizons.libraries.electronwill.nightconfig.core.Config;
import DistantHorizons.libraries.electronwill.nightconfig.json.JsonFormat;
import com.seibel.distanthorizons.core.jar.installer.MarkdownFormatter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import javax.net.ssl.HttpsURLConnection;

public class WebDownloader {
    public static boolean netIsAvailable() {
        try {
            URL url = new URL("https://example.com");
            URLConnection conn = url.openConnection();
            conn.connect();
            conn.getInputStream().close();
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static void downloadAsFile(URL url, File file) throws Exception {
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        long filesize = connection.getContentLengthLong();
        if (filesize == -1L) {
            throw new Exception("Content length must not be -1 (unknown)!");
        }
        long totalDataRead = 0L;
        try (BufferedInputStream in = new BufferedInputStream(connection.getInputStream());){
            FileOutputStream fos = new FileOutputStream(file);
            try (BufferedOutputStream bout = new BufferedOutputStream(fos, 1024);){
                int i;
                byte[] data = new byte[1024];
                int percent = -1;
                while ((i = in.read(data, 0, 1024)) >= 0) {
                    bout.write(data, 0, i);
                    int newPercent = (int)((totalDataRead += (long)i) * 100L / filesize);
                    if (percent == newPercent) continue;
                    percent = newPercent;
                    System.out.println(String.valueOf(percent) + "% downloaded");
                }
            }
        }
    }

    public static String downloadAsString(URL url) throws Exception {
        String line;
        StringBuilder stringBuilder = new StringBuilder();
        URLConnection urlConnection = url.openConnection();
        urlConnection.setConnectTimeout(1000);
        urlConnection.setReadTimeout(1000);
        BufferedReader bReader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
        while ((line = bReader.readLine()) != null) {
            stringBuilder.append(line);
        }
        return stringBuilder.toString();
    }

    public static String formatMarkdownToHtml(String md, int width) {
        String str = String.format("<html><div style=\"width:%dpx;\">%s</div></html>", width, md);
        return new MarkdownFormatter.HTMLFormat().convertTo(str);
    }

    public static Config parseWebJson(String url) throws Exception {
        return WebDownloader.parseWebJson(new URL(url));
    }

    public static Config parseWebJson(URL url) throws Exception {
        return JsonFormat.minimalInstance().createParser().parse(WebDownloader.downloadAsString(url));
    }

    public static ArrayList<Config> parseWebJsonList(String url) throws Exception {
        return WebDownloader.parseWebJsonList(new URL(url));
    }

    public static ArrayList<Config> parseWebJsonList(URL url) throws Exception {
        return (ArrayList)JsonFormat.minimalInstance().createParser().parse("{\"E\":" + WebDownloader.downloadAsString(url) + "}").get("E");
    }

    private static String checksum(String filepath, MessageDigest md) throws IOException {
        try (DigestInputStream dis = new DigestInputStream(new FileInputStream(filepath), md);){
            while (dis.read() != -1) {
            }
            md = dis.getMessageDigest();
        }
        StringBuilder result = new StringBuilder();
        for (byte b : md.digest()) {
            result.append(String.format("%02x", b));
        }
        return result.toString();
    }
}

