/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.jar;

import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.jar.EPlatform;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IModChecker;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class JarUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    public static File jarFile = null;

    public static URI accessFileURI(String resource) throws URISyntaxException {
        return Objects.requireNonNull(JarUtils.class.getResource(resource)).toURI();
    }

    public static InputStream accessFile(String resource) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream input = loader.getResourceAsStream(resource);
        if (input == null) {
            input = loader.getResourceAsStream(resource);
        }
        return input;
    }

    public static String convertInputStreamToString(InputStream inputStream) {
        char[] buffer = new char[8192];
        StringBuilder result = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            int charsRead;
            while ((charsRead = ((Reader)reader).read(buffer, 0, buffer.length)) > 0) {
                result.append(buffer, 0, charsRead);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    public static String getFileChecksum(MessageDigest digest, File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        byte[] byteArray = new byte[1024];
        int bytesCount = 0;
        while ((bytesCount = fis.read(byteArray)) != -1) {
            digest.update(byteArray, 0, bytesCount);
        }
        fis.close();
        byte[] bytes = digest.digest();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    @Deprecated
    public static OperatingSystem getOperatingSystem() {
        switch (EPlatform.get()) {
            case WINDOWS: {
                return OperatingSystem.WINDOWS;
            }
            case LINUX: {
                return OperatingSystem.LINUX;
            }
            case MACOS: {
                return OperatingSystem.MACOS;
            }
        }
        return OperatingSystem.NONE;
    }

    static {
        try {
            jarFile = new File(JarUtils.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (Exception e) {
            try {
                LOGGER.warn("Unable to get the jar file, trying backup method... Error: " + e.getMessage(), (Throwable)e);
                jarFile = SingletonInjector.INSTANCE.get(IModChecker.class).modLocation("distanthorizons");
            }
            catch (Exception f) {
                LOGGER.warn("Backup jar file getter failed. Error: " + f.getMessage(), (Throwable)f);
            }
        }
    }

    @Deprecated
    public static enum OperatingSystem {
        WINDOWS,
        MACOS,
        LINUX,
        NONE;

    }
}

