/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.recipes;

import com.lazrproductions.cuffed.CuffedMod;
import com.lazrproductions.cuffed.init.ModItems;
import com.lazrproductions.cuffed.init.ModRecipes;
import com.lazrproductions.cuffed.items.KeyRingItem;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class KeyRingAddRecipe
extends CustomRecipe {
    public KeyRingAddRecipe(ResourceLocation idIn, CraftingBookCategory category) {
        super(idIn, category);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level level) {
        ItemStack ringStack = null;
        ArrayList<ItemStack> keyStack = new ArrayList<ItemStack>(0);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            if (inv.m_8020_(i).m_41619_()) continue;
            if (inv.m_8020_(i).m_150930_((Item)ModItems.KEY.get()) || inv.m_8020_(i).m_150930_((Item)ModItems.KEY_RING.get())) {
                ItemStack stack = inv.m_8020_(i);
                Item item = stack.m_41720_();
                if (ringStack == null && item == ModItems.KEY_RING.get()) {
                    ringStack = stack;
                }
                if (item != ModItems.KEY.get()) continue;
                keyStack.add(stack);
                continue;
            }
            return false;
        }
        if (ringStack != null && ringStack.m_41784_().m_128451_("Keys") + keyStack.size() > (Integer)CuffedMod.SERVER_CONFIG.MAX_KEYS_PER_RING.get()) {
            return false;
        }
        if (ringStack == null || keyStack.size() == 0) {
            return false;
        }
        return ringStack != null && keyStack.size() > 0;
    }

    public ItemStack assemble(@Nonnull CraftingContainer inv, @Nonnull RegistryAccess access) {
        ItemStack ringStack = null;
        ArrayList<ItemStack> keyStacks = new ArrayList<ItemStack>(0);
        if (this.matches(inv, null)) {
            for (int i = 0; i < inv.m_6643_(); ++i) {
                ItemStack stack = inv.m_8020_(i);
                Item item = stack.m_41720_();
                if (ringStack == null && item == ModItems.KEY_RING.get()) {
                    ringStack = stack;
                }
                if (item != ModItems.KEY.get()) continue;
                keyStacks.add(stack);
            }
            if (ringStack != null) {
                ItemStack newStack = ringStack.m_41777_();
                newStack.m_41764_(1);
                int keys = 2;
                if (newStack.m_41783_() != null) {
                    keys = newStack.m_41784_().m_128451_("Keys");
                }
                for (ItemStack stack : keyStacks) {
                    if (!stack.m_41784_().m_128441_("Id")) continue;
                    KeyRingItem.addKey(newStack, stack);
                }
                newStack.m_41784_().m_128405_("Keys", keys + keyStacks.size());
                return newStack;
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.KEY_RING_ADD.get();
    }
}

