/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.init;

import com.lazrproductions.cuffed.restraints.base.AbstractRestraint;
import com.lazrproductions.cuffed.restraints.custom.FuzzyHandcuffsRestraint;
import com.lazrproductions.cuffed.restraints.custom.HandcuffsArmsRestraint;
import com.lazrproductions.cuffed.restraints.custom.HandcuffsLegsRestraint;
import com.lazrproductions.cuffed.restraints.custom.ShacklesArmsRestraint;
import com.lazrproductions.cuffed.restraints.custom.ShacklesLegsRestraint;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ModStatistics {
    private static final DeferredRegister<ResourceLocation> REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256887_, (String)"cuffed");
    private static final List<Runnable> RUN_IN_SETUP = new ArrayList<Runnable>();
    public static final RegistryObject<ResourceLocation> HANDCUFFS_TIME_RESTRAINED = ModStatistics.registerCustomStat("handcuffs_times_restrained", StatFormatter.f_12873_);
    public static final RegistryObject<ResourceLocation> HANDCUFFS_BROKEN = ModStatistics.registerCustomStat("handcuffs_broken", StatFormatter.f_12873_);
    public static final RegistryObject<ResourceLocation> HANDCUFFS_TIME_SPENT_RESTRAINED = ModStatistics.registerCustomStat("handcuffs_time_spent_restrained", StatFormatter.f_12876_);
    public static final RegistryObject<ResourceLocation> FUZZY_HANDCUFFS_TIME_RESTRAINED = ModStatistics.registerCustomStat("fuzzy_handcuffs_times_restrained", StatFormatter.f_12873_);
    public static final RegistryObject<ResourceLocation> FUZZY_HANDCUFFS_BROKEN = ModStatistics.registerCustomStat("fuzzy_handcuffs_broken", StatFormatter.f_12873_);
    public static final RegistryObject<ResourceLocation> FUZZY_HANDCUFFS_TIME_SPENT_RESTRAINED = ModStatistics.registerCustomStat("fuzzy_handcuffs_time_spent_restrained", StatFormatter.f_12876_);
    public static final RegistryObject<ResourceLocation> SHACKLES_TIME_RESTRAINED = ModStatistics.registerCustomStat("shackles_times_restrained", StatFormatter.f_12873_);
    public static final RegistryObject<ResourceLocation> SHACKLES_BROKEN = ModStatistics.registerCustomStat("shackles_broken", StatFormatter.f_12873_);
    public static final RegistryObject<ResourceLocation> SHACKLES_TIME_SPENT_RESTRAINED = ModStatistics.registerCustomStat("shackles_time_spent_restrained", StatFormatter.f_12876_);
    public static final RegistryObject<ResourceLocation> LEGCUFFS_TIME_RESTRAINED = ModStatistics.registerCustomStat("legcuffs_times_restrained", StatFormatter.f_12873_);
    public static final RegistryObject<ResourceLocation> LEGCUFFS_BROKEN = ModStatistics.registerCustomStat("legcuffs_broken", StatFormatter.f_12873_);
    public static final RegistryObject<ResourceLocation> LEGCUFFS_TIME_SPENT_RESTRAINED = ModStatistics.registerCustomStat("legcuffs_time_spent_restrained", StatFormatter.f_12876_);
    public static final RegistryObject<ResourceLocation> LEG_SHACKLES_TIME_RESTRAINED = ModStatistics.registerCustomStat("leg_shackles_times_restrained", StatFormatter.f_12873_);
    public static final RegistryObject<ResourceLocation> LEG_SHACKLES_BROKEN = ModStatistics.registerCustomStat("leg_shackles_broken", StatFormatter.f_12873_);
    public static final RegistryObject<ResourceLocation> LEG_SHACKLES_TIME_SPENT_RESTRAINED = ModStatistics.registerCustomStat("leg_shackles_time_spent_restrained", StatFormatter.f_12876_);
    public static final RegistryObject<ResourceLocation> TIMES_NICKNAMED = ModStatistics.registerCustomStat("times_nicknamed", StatFormatter.f_12873_);
    public static final RegistryObject<ResourceLocation> SUCCESSFUL_LOCKPICKS = ModStatistics.registerCustomStat("successful_lockpicks", StatFormatter.f_12873_);
    public static final RegistryObject<ResourceLocation> LOCKPICKS_BROKEN = ModStatistics.registerCustomStat("lockpicks_broken", StatFormatter.f_12873_);
    public static final RegistryObject<ResourceLocation> OPEN_SAFE = ModStatistics.registerCustomStat("open_safe", StatFormatter.f_12873_);

    public static void register(IEventBus bus) {
        REGISTER.register(bus);
    }

    public static void setup() {
        RUN_IN_SETUP.forEach(Runnable::run);
    }

    private static RegistryObject<ResourceLocation> registerCustomStat(String name, StatFormatter formatter) {
        return REGISTER.register(name, () -> {
            ResourceLocation regName = new ResourceLocation("cuffed", name);
            RUN_IN_SETUP.add(() -> Stats.f_12988_.m_12899_((Object)regName, formatter));
            return regName;
        });
    }

    public static void awardRestraintItemUsed(@Nonnull ServerPlayer player, @Nonnull ItemStack stack) {
        player.m_6278_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()), 1);
    }

    public static void awardRestrained(@Nonnull ServerPlayer player, @Nonnull AbstractRestraint restraint) {
        if (restraint instanceof HandcuffsArmsRestraint) {
            player.m_36222_((ResourceLocation)HANDCUFFS_TIME_RESTRAINED.get(), 1);
        } else if (restraint instanceof FuzzyHandcuffsRestraint) {
            player.m_36222_((ResourceLocation)FUZZY_HANDCUFFS_TIME_RESTRAINED.get(), 1);
        } else if (restraint instanceof ShacklesArmsRestraint) {
            player.m_36222_((ResourceLocation)SHACKLES_TIME_RESTRAINED.get(), 1);
        } else if (restraint instanceof HandcuffsLegsRestraint) {
            player.m_36222_((ResourceLocation)LEGCUFFS_TIME_RESTRAINED.get(), 1);
        } else if (restraint instanceof ShacklesLegsRestraint) {
            player.m_36222_((ResourceLocation)LEG_SHACKLES_TIME_RESTRAINED.get(), 1);
        }
    }

    public static void awardRestraintBroken(@Nonnull ServerPlayer player, @Nonnull AbstractRestraint restraint) {
        if (restraint instanceof HandcuffsArmsRestraint) {
            player.m_36222_((ResourceLocation)HANDCUFFS_BROKEN.get(), 1);
        } else if (restraint instanceof FuzzyHandcuffsRestraint) {
            player.m_36222_((ResourceLocation)FUZZY_HANDCUFFS_BROKEN.get(), 1);
        } else if (restraint instanceof ShacklesArmsRestraint) {
            player.m_36222_((ResourceLocation)SHACKLES_BROKEN.get(), 1);
        } else if (restraint instanceof HandcuffsLegsRestraint) {
            player.m_36222_((ResourceLocation)LEGCUFFS_BROKEN.get(), 1);
        } else if (restraint instanceof ShacklesLegsRestraint) {
            player.m_36222_((ResourceLocation)LEG_SHACKLES_BROKEN.get(), 1);
        }
    }

    public static void awardTimeSpentRestrained(@Nonnull ServerPlayer player, @Nonnull AbstractRestraint restraint) {
        if (restraint instanceof HandcuffsArmsRestraint) {
            player.m_36222_((ResourceLocation)HANDCUFFS_TIME_SPENT_RESTRAINED.get(), 1);
        } else if (restraint instanceof FuzzyHandcuffsRestraint) {
            player.m_36222_((ResourceLocation)FUZZY_HANDCUFFS_TIME_SPENT_RESTRAINED.get(), 1);
        } else if (restraint instanceof ShacklesArmsRestraint) {
            player.m_36222_((ResourceLocation)SHACKLES_TIME_SPENT_RESTRAINED.get(), 1);
        } else if (restraint instanceof HandcuffsLegsRestraint) {
            player.m_36222_((ResourceLocation)LEGCUFFS_TIME_SPENT_RESTRAINED.get(), 1);
        } else if (restraint instanceof ShacklesLegsRestraint) {
            player.m_36222_((ResourceLocation)LEG_SHACKLES_TIME_SPENT_RESTRAINED.get(), 1);
        }
    }
}

