/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.client.gui.screen;

import com.lazrproductions.cuffed.api.CuffedAPI;
import com.lazrproductions.cuffed.client.gui.screen.GenericScreen;
import com.lazrproductions.lazrslib.client.screen.ScreenUtilities;
import com.lazrproductions.lazrslib.client.screen.base.BlitCoordinates;
import com.lazrproductions.lazrslib.client.screen.base.ScreenTexture;
import com.lazrproductions.lazrslib.common.math.MathUtilities;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Random;

@OnlyIn(value=Dist.CLIENT)
public class LockpickingScreen
extends GenericScreen {
    static final float TARGET_BUFFER = 5.0f;
    public float secondsPerPhase = 1.0f;
    public int speedIncreasePerPhase = 10;
    public int progressPerPick = 8;
    public int type = 0;
    public int lockId = -1;
    public String restrainedUUID;
    public int restraintType;
    public BlockPos doorPos = null;
    int currentPhase = 0;
    float ticksLeftToPick = 20.0f;
    float currentTargetPick = 0.0f;
    float animationTick;
    boolean isAnimating = false;
    float lerpedGhostAngle = 0.0f;

    public LockpickingScreen(Minecraft instance) {
        super(instance);
        this.startLockpicking();
    }

    @Override
    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.f_96541_ != null) {
            this.renderContent(this.f_96541_, graphics, mouseX, mouseY, partialTick);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public void renderContent(@Nonnull Minecraft instance, @Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (!this.isAnimating) {
            if (this.ticksLeftToPick > 0.0f) {
                if (this.ticksLeftToPick >= 40.0f) {
                    this.completeLockpicking(instance);
                }
                this.ticksLeftToPick -= (float)(this.currentPhase + 1) * ((float)this.speedIncreasePerPhase / 200.0f);
            } else {
                this.failLockpicking(instance);
            }
        } else {
            LocalPlayer player;
            this.animationTick -= partialTick;
            if (this.ticksLeftToPick < 0.0f && this.animationTick % 2.0f == 0.0f && (player = instance.f_91074_) != null) {
                player.m_5496_(SoundEvents.f_11745_, 1.0f, 0.7f);
            }
            if (this.animationTick <= 0.0f) {
                this.animationTick = 0.0f;
                this.isAnimating = false;
            }
        }
        int centerScreenX = graphics.m_280182_() / 2;
        int centerScreenY = graphics.m_280206_() / 2;
        int shakeOffset = Mth.m_14143_((float)((Mth.m_14031_((float)(this.animationTick * 2.0f)) - 0.5f) * 3.0f));
        int scale = 3;
        int originalSize = 32;
        int finalSize = originalSize * scale;
        ScreenUtilities.drawTexture((GuiGraphics)graphics, (BlitCoordinates)new BlitCoordinates(centerScreenX - finalSize / 2 + shakeOffset, centerScreenY - 16 * scale, finalSize, finalSize), (ScreenTexture)new ScreenTexture(new ResourceLocation("cuffed", "textures/item/padlock.png"), 0.0f, 0.0f, 16, 16, 16, 16));
        ScreenUtilities.drawGenericProgressBarUpright((GuiGraphics)graphics, (BlitCoordinates)new BlitCoordinates(centerScreenX - finalSize, Mth.m_14143_((float)((float)centerScreenY - (float)finalSize / 2.0f)), 4, finalSize), (float)(this.ticksLeftToPick / 40.0f), (float)partialTick);
        int pickPosX = Mth.m_14143_((float)((float)centerScreenX - (float)finalSize * 0.75f)) - 8;
        int pickPosY = Mth.m_14143_((float)centerScreenY) - 6;
        float angleToMouse = 0.0f;
        Vec2 mouseDelta = new Vec2(Mth.m_14036_((float)(mouseX - centerScreenX), (float)-100.0f, (float)100.0f) / 100.0f, Mth.m_14036_((float)(mouseY - centerScreenY - 16), (float)-100.0f, (float)100.0f) / 100.0f);
        angleToMouse = (float)Mth.m_14136_((double)mouseDelta.f_82471_, (double)mouseDelta.f_82470_) * 57.295776f + 225.0f;
        float angleToCurrentGhost = -(90.0f * (this.currentTargetPick / (this.secondsPerPhase * 20.0f))) + 360.0f;
        this.lerpedGhostAngle = Mth.m_14179_((float)(partialTick * 4.0f), (float)this.lerpedGhostAngle, (float)angleToCurrentGhost);
        if (this.ticksLeftToPick < 40.0f) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            RenderSystem.enableBlend();
            ScreenUtilities.drawTexture((GuiGraphics)graphics, (BlitCoordinates)new BlitCoordinates(pickPosX, pickPosY, finalSize, finalSize), (float)this.lerpedGhostAngle, (float)(26 * scale), (float)(8 * scale), (ScreenTexture)new ScreenTexture(new ResourceLocation("cuffed", "textures/item/lockpick.png"), 0.0f, 0.0f, 16, 16, 16, 16));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)MathUtilities.invert01((double)((double)this.animationTick / 5.0))));
            ScreenUtilities.drawTexture((GuiGraphics)graphics, (BlitCoordinates)new BlitCoordinates(pickPosX, pickPosY, finalSize, finalSize), (float)angleToMouse, (float)(26 * scale), (float)(8 * scale), (ScreenTexture)new ScreenTexture(new ResourceLocation("cuffed", "textures/item/lockpick.png"), 0.0f, 0.0f, 16, 16, 16, 16));
        }
        if (this.lastMouseInput.getAction() == 0 && this.lastMouseInput.getInput() == 0 && angleToMouse > angleToCurrentGhost - 10.0f && angleToMouse < angleToCurrentGhost + 5.0f) {
            this.beginNewPhase(instance);
        }
    }

    void beginNewPhase(@Nonnull Minecraft instance) {
        ++this.currentPhase;
        this.ticksLeftToPick += (float)this.progressPerPick;
        LocalPlayer player = instance.f_91074_;
        if (player != null) {
            player.m_5496_(SoundEvents.f_11746_, 1.0f, 0.7f + this.ticksLeftToPick / 40.0f);
        }
        this.animationTick = 5.0f;
        this.isAnimating = true;
        this.assignNewGhost();
    }

    void startLockpicking() {
        this.currentPhase = 0;
        this.ticksLeftToPick = 30.0f;
        this.assignNewGhost();
    }

    void failLockpicking(@Nonnull Minecraft instance) {
        LocalPlayer player = instance.f_91074_;
        if (player != null) {
            switch (this.type) {
                case 0: {
                    CuffedAPI.Networking.sendLockpickFinishPickingLockPacketToServer(true, this.lockId, player.m_20148_());
                    break;
                }
                case 1: {
                    CuffedAPI.Networking.sendLockpickFinishPickingRestraintPacketToServer(true, this.restrainedUUID, this.restraintType, player.m_20148_());
                    break;
                }
                case 2: {
                    CuffedAPI.Networking.sendLockpickFinishPickingCellDoorPacketToServer(true, this.doorPos, player.m_20148_());
                }
            }
            instance.m_91152_(null);
        }
    }

    void completeLockpicking(@Nonnull Minecraft instance) {
        LocalPlayer player = instance.f_91074_;
        if (player != null) {
            switch (this.type) {
                case 0: {
                    CuffedAPI.Networking.sendLockpickFinishPickingLockPacketToServer(false, this.lockId, player.m_20148_());
                    break;
                }
                case 1: {
                    CuffedAPI.Networking.sendLockpickFinishPickingRestraintPacketToServer(false, this.restrainedUUID, this.restraintType, player.m_20148_());
                    break;
                }
                case 2: {
                    CuffedAPI.Networking.sendLockpickFinishPickingCellDoorPacketToServer(false, this.doorPos, player.m_20148_());
                }
            }
            instance.m_91152_(null);
        }
        instance.m_91152_(null);
    }

    void assignNewGhost() {
        Random r = new Random();
        this.currentTargetPick = r.nextFloat() * (this.secondsPerPhase * 20.0f);
    }
}

