/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.client.gui.screen;

import com.lazrproductions.cuffed.client.gui.screen.GenericScreen;
import com.lazrproductions.lazrslib.client.font.FontUtilities;
import com.lazrproductions.lazrslib.client.screen.ScreenUtilities;
import com.lazrproductions.lazrslib.client.screen.base.BlitCoordinates;
import com.lazrproductions.lazrslib.client.screen.base.ScreenRect;
import com.lazrproductions.lazrslib.client.screen.base.ScreenTexture;
import com.lazrproductions.lazrslib.client.ui.Alignment;
import com.lazrproductions.lazrslib.client.ui.UIUtilities;
import com.lazrproductions.lazrslib.client.ui.element.AbstractElement;
import com.lazrproductions.lazrslib.client.ui.element.HorizontalElement;
import com.lazrproductions.lazrslib.client.ui.element.ItemIconElement;
import com.lazrproductions.lazrslib.client.ui.element.LinkElement;
import com.lazrproductions.lazrslib.client.ui.element.ScaledTextureElement;
import com.lazrproductions.lazrslib.client.ui.element.TextElement;
import com.lazrproductions.lazrslib.client.ui.element.TextureElement;
import com.lazrproductions.lazrslib.client.ui.element.VerticalElement;
import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector2i;

@OnlyIn(value=Dist.CLIENT)
public class InformationBookletScreen
extends GenericScreen {
    public static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("cuffed", "textures/gui/information_booklet.png");
    private static final int FIXED_PAGE_HEIGHT = 202;
    private static final ScreenTexture FRONT_COVER_PAGE = new ScreenTexture(TEXTURE_LOCATION, 146.0f, 0.0f, 146, 180, 512, 512);
    private static final ScreenTexture BACK_COVER_PAGE = new ScreenTexture(TEXTURE_LOCATION, 0.0f, 0.0f, 146, 180, 512, 512);
    private static final ScreenTexture BASIC_LEFT_PAGE = new ScreenTexture(TEXTURE_LOCATION, 0.0f, 180.0f, 146, 180, 512, 512);
    private static final ScreenTexture BASIC_RIGHT_PAGE = new ScreenTexture(TEXTURE_LOCATION, 146.0f, 180.0f, 146, 180, 512, 512);
    private static final ScreenTexture RIGHT_BUTTON = new ScreenTexture(TEXTURE_LOCATION, 0.0f, 360.0f, 18, 10, 512, 512);
    private static final ScreenTexture RIGHT_BUTTON_HIGHLIGHTED = new ScreenTexture(TEXTURE_LOCATION, 18.0f, 360.0f, 18, 10, 512, 512);
    private static final ScreenTexture LEFT_BUTTON = new ScreenTexture(TEXTURE_LOCATION, 0.0f, 370.0f, 18, 10, 512, 512);
    private static final ScreenTexture LEFT_BUTTON_HIGHLIGHTED = new ScreenTexture(TEXTURE_LOCATION, 18.0f, 370.0f, 18, 10, 512, 512);
    private static final ScreenTexture BACK_BUTTON = new ScreenTexture(TEXTURE_LOCATION, 35.0f, 399.0f, 18, 10, 512, 512);
    private static final ScreenTexture BACK_BUTTON_HIGHLIGHTED = new ScreenTexture(TEXTURE_LOCATION, 53.0f, 399.0f, 18, 10, 512, 512);
    private static final ScreenTexture HOME_BUTTON = new ScreenTexture(TEXTURE_LOCATION, 0.0f, 381.0f, 11, 11, 512, 512);
    private static final ScreenTexture HOME_BUTTON_HIGHLIGHTED = new ScreenTexture(TEXTURE_LOCATION, 11.0f, 381.0f, 11, 11, 512, 512);
    static final int WRITING_COLOR = FastColor.ARGB32.m_13660_((int)255, (int)148, (int)116, (int)90);
    static final int HIGHLIGHTED_COLOR = -16736257;
    public ArrayList<GenericPage> pages;
    HashMap<String, Integer> encyclopediaMap = new HashMap();
    int currentPage = 0;
    int previousPage = -1;
    int pageHeight;
    int pageWidth;

    public InformationBookletScreen(Minecraft instance) {
        super(instance);
    }

    @Override
    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.pageHeight = 202;
        this.pageWidth = Mth.m_14143_((float)((float)this.pageHeight * 0.8111111f));
        if (this.f_96541_ != null) {
            this.drawContent(graphics, partialTick);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public void drawContent(@Nonnull GuiGraphics graphics, float partialTick) {
        int y;
        int x;
        int w;
        this.assemblePages(this.f_96541_);
        GenericPage page = this.pages.get(this.currentPage);
        this.m_280273_(graphics);
        this.pages.get(this.currentPage).renderPage(this.f_96541_, graphics, partialTick, this.mouseX, this.mouseY, this.lastMouseInput.getAction() == 1 && this.lastMouseInput.getInput() == 0);
        if (this.pages.get(this.currentPage) instanceof DoublePage) {
            int l_pN = this.currentPage * 2 - 1;
            int r_pN = l_pN + 1;
            MutableComponent l_pageNumber = Component.m_237113_((String)("" + l_pN));
            Objects.requireNonNull(this.f_96541_.f_91062_);
            int l_h = Mth.m_14143_((float)9.0f);
            int l_w = Mth.m_14143_((float)this.f_96541_.f_91062_.m_92852_((FormattedText)l_pageNumber));
            int l_x = Mth.m_14143_((float)(page.getPageRect().getFromX() + 26));
            int l_y = Mth.m_14143_((float)(page.getPageRect().getToY() - l_h - 12));
            FontUtilities.drawText((Minecraft)this.f_96541_, (GuiGraphics)graphics, (BlitCoordinates)new BlitCoordinates(l_x, l_y, l_w, l_h), (Component)l_pageNumber, (int)WRITING_COLOR, (boolean)false);
            MutableComponent r_pageNumber = Component.m_237113_((String)("" + r_pN));
            Objects.requireNonNull(this.f_96541_.f_91062_);
            int r_h = Mth.m_14143_((float)9.0f);
            int r_w = Mth.m_14143_((float)this.f_96541_.f_91062_.m_92852_((FormattedText)l_pageNumber));
            int r_x = Mth.m_14143_((float)(page.getPageRect().getToX() - r_w - 26));
            int r_y = Mth.m_14143_((float)(page.getPageRect().getToY() - r_h - 12));
            FontUtilities.drawText((Minecraft)this.f_96541_, (GuiGraphics)graphics, (BlitCoordinates)new BlitCoordinates(r_x, r_y, r_w, r_h), (Component)r_pageNumber, (int)WRITING_COLOR, (boolean)false);
        }
        boolean pageWasChanged = false;
        if (this.currentPage > 1) {
            float aspectRatioOfTexture = 1.0f;
            int h = Mth.m_14143_((float)10.0f);
            w = Mth.m_14143_((float)((float)h * aspectRatioOfTexture));
            x = Mth.m_14143_((float)(page.getPageRect().getFromX() + this.pageWidth / 2 - Mth.m_14143_((float)18.0f) / 2)) - 4 - w;
            if (InformationBookletScreen.drawButton(graphics, new BlitCoordinates(x, y = Mth.m_14143_((float)(page.getPageRect().getToY() - h - 12)), w, h), HOME_BUTTON, HOME_BUTTON_HIGHLIGHTED, this.mouseX, this.mouseY, this.lastMouseInput.getAction() == 1 && this.lastMouseInput.getInput() == 0)) {
                this.setPage(this.f_96541_, 1);
                pageWasChanged = true;
            }
        }
        if (this.previousPage > -1) {
            float aspectRatioOfTexture = 1.8f;
            int h = Mth.m_14143_((float)10.0f);
            w = Mth.m_14143_((float)((float)h * aspectRatioOfTexture));
            x = Mth.m_14143_((float)(page.getPageRect().getFromX() + 18));
            if (InformationBookletScreen.drawButton(graphics, new BlitCoordinates(x, y = Mth.m_14143_((float)(page.getPageRect().getFromY() + 14)), w, h), BACK_BUTTON, BACK_BUTTON_HIGHLIGHTED, this.mouseX, this.mouseY, this.lastMouseInput.getAction() == 1 && this.lastMouseInput.getInput() == 0)) {
                this.setPage(this.f_96541_, this.previousPage);
                this.previousPage = -1;
                pageWasChanged = true;
            }
        }
        if (this.currentPage > 0) {
            float aspectRatioOfTexture = 1.8f;
            int h = Mth.m_14143_((float)10.0f);
            w = Mth.m_14143_((float)((float)h * aspectRatioOfTexture));
            x = Mth.m_14143_((float)(page.getPageRect().getFromX() + this.pageWidth / 2 - w / 2));
            if (InformationBookletScreen.drawButton(graphics, new BlitCoordinates(x, y = Mth.m_14143_((float)(page.getPageRect().getToY() - h - 12)), w, h), LEFT_BUTTON, LEFT_BUTTON_HIGHLIGHTED, this.mouseX, this.mouseY, this.lastMouseInput.getAction() == 1 && this.lastMouseInput.getInput() == 0)) {
                --this.currentPage;
                this.previousPage = -1;
                pageWasChanged = true;
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
            }
        }
        if (!pageWasChanged && this.currentPage + 1 < this.pages.size()) {
            float aspectRatioOfTexture = 1.8f;
            int h = Mth.m_14143_((float)10.0f);
            w = Mth.m_14143_((float)((float)h * aspectRatioOfTexture));
            x = Mth.m_14143_((float)(page.getPageRect().getToX() - this.pageWidth / 2 - w / 2));
            if (InformationBookletScreen.drawButton(graphics, new BlitCoordinates(x, y = Mth.m_14143_((float)(page.getPageRect().getToY() - h - 12)), w, h), RIGHT_BUTTON, RIGHT_BUTTON_HIGHLIGHTED, this.mouseX, this.mouseY, this.lastMouseInput.getAction() == 1 && this.lastMouseInput.getInput() == 0)) {
                ++this.currentPage;
                this.previousPage = -1;
                this.f_96541_.f_91074_.m_216990_(SoundEvents.f_11713_);
            }
        }
    }

    public void setPage(@Nonnull Minecraft insance, int value) {
        this.previousPage = this.currentPage;
        this.currentPage = value;
        insance.f_91074_.m_216990_(SoundEvents.f_11713_);
    }

    public void assemblePages(@Nonnull Minecraft instance) {
        this.pageHeight = 202;
        this.pageWidth = Mth.m_14143_((float)((float)this.pageHeight * 0.8111111f));
        int contentWidth = this.pageWidth - 24 - 24;
        this.pages = new ArrayList();
        this.pages.add(new CoverPage(FRONT_COVER_PAGE));
        this.pages.add(new DoublePage(new ComplexPage(BASIC_LEFT_PAGE, new VerticalElement(BlitCoordinates.DEFAULT, 2, new HorizontalElement[]{new HorizontalElement(new AbstractElement[]{new TextureElement(instance, new ScreenTexture(TEXTURE_LOCATION, 438.0f, 253.0f, 65, 23, 512, 512), Alignment.CENTER, Mth.m_14143_((float)27.756f))}), new HorizontalElement(new AbstractElement[]{new ScaledTextureElement(instance, GenericPage.SEPARATOR_TEXTURE, Mth.m_14143_((float)((float)contentWidth * 0.09615385f)))}), new HorizontalElement(new AbstractElement[]{new TextElement(instance, contentWidth, (Component)Component.m_237115_((String)"guide.cuffed.title_page.info"), WRITING_COLOR, false)})})), new ComplexPage(BASIC_RIGHT_PAGE, new VerticalElement(BlitCoordinates.DEFAULT, 2, new HorizontalElement[]{new HorizontalElement(new AbstractElement[]{new TextElement(instance, contentWidth, (Component)Component.m_237113_((String)"Warden's guide has been discontinued, use the"), WRITING_COLOR, false)}), new HorizontalElement(new AbstractElement[]{new LinkElement(instance, contentWidth, (Component)Component.m_237113_((String)"Official Cuffed Wiki"), Alignment.CENTER, () -> {}, WRITING_COLOR, -16736257)}), new HorizontalElement(new AbstractElement[]{new TextElement(instance, contentWidth, (Component)Component.m_237113_((String)"to find information about the mod."), WRITING_COLOR, false)})}))));
        this.pages.add(new CoverPage(BACK_COVER_PAGE));
    }

    public int getItemEncyclopediaPage(Item item) {
        return this.getItemEncyclopediaPage(new ItemStack((ItemLike)item));
    }

    public int getItemEncyclopediaPage(ItemStack stack) {
        return this.getItemEncyclopediaPage(stack.m_41778_());
    }

    public int getItemEncyclopediaPage(String path) {
        return this.encyclopediaMap.containsKey(path) ? this.encyclopediaMap.get(path) : 0;
    }

    public DoublePage createItemEncyclopediaPage(int wouldBeIndex, @Nonnull Minecraft instance, Item item, int contentWidth) {
        return this.createItemEncyclopediaPage(wouldBeIndex, instance, new ItemStack((ItemLike)item), contentWidth);
    }

    public DoublePage createItemEncyclopediaPage(int wouldBeIndex, @Nonnull Minecraft instance, ItemStack stack, int contentWidth) {
        return this.createItemEncyclopediaPage(wouldBeIndex, instance, stack.m_41720_().m_5524_(), stack, contentWidth);
    }

    public DoublePage createItemEncyclopediaPage(int wouldBeIndex, @Nonnull Minecraft instance, String path, ItemStack stack, int contentWidth) {
        if (!this.encyclopediaMap.containsKey(path)) {
            this.encyclopediaMap.put(path, wouldBeIndex);
        } else {
            this.encyclopediaMap.replace(path, wouldBeIndex);
        }
        return new DoublePage(new ComplexPage(BASIC_LEFT_PAGE, new VerticalElement(BlitCoordinates.DEFAULT, new HorizontalElement[]{new HorizontalElement(new AbstractElement[]{new TextElement(instance, contentWidth - 36, (Component)Component.m_237115_((String)path).m_130940_(ChatFormatting.BOLD), WRITING_COLOR, false), new ItemIconElement(instance, stack, Alignment.CENTER_RIGHT, 36)}), new HorizontalElement(new AbstractElement[]{new TextElement(instance, contentWidth, (Component)Component.m_237115_((String)(path + ".desc")), WRITING_COLOR, false)})})), new BlankPage(BASIC_RIGHT_PAGE));
    }

    public static boolean drawButton(GuiGraphics graphics, BlitCoordinates pos, ScreenTexture texture, ScreenTexture highlightedTexture, double mouseX, double mouseY, boolean mouseDown) {
        ScreenRect area = pos.toRect();
        if (area.positionEnvlopes(mouseX, mouseY)) {
            ScreenUtilities.drawTexture((GuiGraphics)graphics, (BlitCoordinates)pos, (ScreenTexture)highlightedTexture);
            if (mouseDown) {
                return true;
            }
        } else {
            ScreenUtilities.drawTexture((GuiGraphics)graphics, (BlitCoordinates)pos, (ScreenTexture)texture);
        }
        return false;
    }

    static abstract class GenericPage {
        static final float PAGE_VERTICAL_PERCENTAGE = 0.8f;
        static final int CONTENT_PADDING_LEFT = 24;
        static final int CONTENT_PADDING_RIGHT = 24;
        static final int CONTENT_PADDING_TOP = 18;
        static final int CONTENT_PADDING_BOTTOM = 28;
        static final int HEADER_HEIGHT = 36;
        static final int ICON_HEIGHT = 36;
        static final int ICON_WIDTH = 36;
        static int SEPARATOR_HEIGHT = 0;
        static final ScreenTexture SEPARATOR_TEXTURE = new ScreenTexture(TEXTURE_LOCATION, 0.0f, 411.0f, 104, 9, 512, 512);
        ResourceLocation PAGE_LOCATION;
        private int screenWidth;
        private int screenHeight;
        private ScreenRect pageRect;
        private ScreenRect contentRect;
        private ScreenTexture backgroundtexture;
        public int pageHorizontalOffset;

        public GenericPage(ScreenTexture background) {
            this.backgroundtexture = background;
            this.calibratePage(Minecraft.m_91087_());
        }

        public void renderPage(@Nonnull Minecraft instance, @Nonnull GuiGraphics graphics, float partialTick, int mouseX, int mouseY, boolean mouseDown) {
            this.calibratePage(instance);
            this.renderBackground(instance, graphics, partialTick, mouseX, mouseY, mouseDown);
            this.renderContent(instance, graphics, partialTick, mouseX, mouseY, mouseDown);
        }

        protected void renderBackground(@Nonnull Minecraft instance, @Nonnull GuiGraphics graphics, float partialTick, int mouseX, int mouseY, boolean mouseDown) {
            ScreenUtilities.drawTexture((GuiGraphics)graphics, (BlitCoordinates)this.getPageBlitCoords(), (ScreenTexture)this.backgroundtexture);
        }

        protected abstract void renderContent(@Nonnull Minecraft var1, @Nonnull GuiGraphics var2, float var3, int var4, int var5, boolean var6);

        private final void calibratePage(@Nonnull Minecraft instance) {
            Window window = Minecraft.m_91087_().m_91268_();
            this.screenWidth = window.m_85445_();
            this.screenHeight = window.m_85446_();
            int centerScreenX = this.screenWidth / 2;
            int centerScreenY = this.screenHeight / 2;
            float aspectRatioOfTexture = (float)this.backgroundtexture.getBoundsX() / (float)this.backgroundtexture.getBoundsY();
            int h = 202;
            int w = Mth.m_14143_((float)((float)h * aspectRatioOfTexture));
            int x = Mth.m_14143_((float)(centerScreenX - w / 2)) + this.pageHorizontalOffset;
            int y = Mth.m_14143_((float)(centerScreenY - h / 2));
            this.pageRect = new BlitCoordinates(x, y, w, h).toRect();
            this.contentRect = new ScreenRect(this.pageRect.getFromX() + 24, this.pageRect.getFromY() + 18, this.pageRect.getToX() - 24, this.pageRect.getToY() - 28);
            SEPARATOR_HEIGHT = Mth.m_14143_((float)((float)this.contentRect.getWidth() / 11.555555f));
        }

        public Vector2i getTopLeft() {
            return this.pageRect.getTopLeft();
        }

        public Vector2i getTopRight() {
            return this.pageRect.getTopRight();
        }

        public Vector2i getBottomLeft() {
            return this.pageRect.getBottomLeft();
        }

        public Vector2i getBottomRight() {
            return this.pageRect.getBottomRight();
        }

        public Vector2i getCenter() {
            return this.pageRect.getCenter();
        }

        public ScreenRect getContentRect() {
            return this.contentRect;
        }

        public BlitCoordinates getContentBlitCoords() {
            return this.getContentRect().toBlitCoordinates();
        }

        public ScreenRect getPageRect() {
            return this.pageRect;
        }

        public BlitCoordinates getPageBlitCoords() {
            return this.getPageRect().toBlitCoordinates();
        }
    }

    static class DoublePage
    extends GenericPage {
        final GenericPage leftPage;
        final GenericPage rightPage;

        public DoublePage(GenericPage leftPage, GenericPage rightPage) {
            super(leftPage.backgroundtexture);
            this.leftPage = leftPage;
            this.leftPage.pageHorizontalOffset = -leftPage.getPageRect().getWidth() / 2;
            this.rightPage = rightPage;
            this.rightPage.pageHorizontalOffset = rightPage.getPageRect().getWidth() / 2;
        }

        @Override
        public void renderPage(@Nonnull Minecraft instance, @Nonnull GuiGraphics graphics, float partialTick, int mouseX, int mouseY, boolean mouseDown) {
            super.renderPage(instance, graphics, partialTick, mouseX, mouseY, mouseDown);
            this.leftPage.renderPage(instance, graphics, partialTick, mouseX, mouseY, mouseDown);
            this.rightPage.renderPage(instance, graphics, partialTick, mouseX, mouseY, mouseDown);
        }

        @Override
        protected void renderBackground(@Nonnull Minecraft instance, @Nonnull GuiGraphics graphics, float partialTick, int mouseX, int mouseY, boolean mouseDown) {
        }

        @Override
        protected void renderContent(@Nonnull Minecraft instance, @Nonnull GuiGraphics graphics, float partialTick, int mouseX, int mouseY, boolean mouseDown) {
        }

        @Override
        public ScreenRect getPageRect() {
            return new ScreenRect(this.leftPage.getPageRect().getFromX(), this.leftPage.getPageRect().getFromY(), this.rightPage.getPageRect().getToX(), this.rightPage.getPageRect().getToY());
        }
    }

    static class CoverPage
    extends GenericPage {
        public CoverPage(ScreenTexture background) {
            super(background);
        }

        @Override
        protected void renderContent(@Nonnull Minecraft instance, @Nonnull GuiGraphics graphics, float partialTick, int mouseX, int mouseY, boolean mouseDown) {
        }
    }

    static class ComplexPage
    extends GenericPage {
        final VerticalElement element;

        public ComplexPage(ScreenTexture background, VerticalElement element) {
            super(background);
            this.element = element;
        }

        @Override
        protected void renderContent(@Nonnull Minecraft instance, @Nonnull GuiGraphics graphics, float partialTick, int mouseX, int mouseY, boolean mouseDown) {
            this.element.setAvailableArea(this.getContentBlitCoords());
            UIUtilities.drawPage((Minecraft)instance, (GuiGraphics)graphics, (int)mouseX, (int)mouseY, (boolean)mouseDown, (VerticalElement)this.element);
        }
    }

    static class BlankPage
    extends GenericPage {
        public BlankPage(ScreenTexture background) {
            super(background);
        }

        @Override
        protected void renderContent(@Nonnull Minecraft instance, @Nonnull GuiGraphics graphics, float partialTick, int mouseX, int mouseY, boolean mouseDown) {
            BlitCoordinates pos = new BlitCoordinates(this.getContentBlitCoords().toRect().getCenter().x() - 18, this.getContentBlitCoords().toRect().getCenter().y() - 18, 36, 36);
            ScreenUtilities.drawTexture((GuiGraphics)graphics, (BlitCoordinates)pos, (ScreenTexture)new ScreenTexture(TEXTURE_LOCATION, 292.0f, 0.0f, 35, 35, 512, 512));
        }
    }
}

