/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.blocks.entity;

import com.lazrproductions.cuffed.blocks.SafeBlock;
import com.lazrproductions.cuffed.init.ModBlockEntities;
import com.lazrproductions.cuffed.init.ModSounds;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SafeBlockEntity
extends RandomizableContainerBlockEntity {
    private UUID lockId;
    private boolean locked = false;
    private boolean hasBeenBound = false;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level p_155062_, BlockPos p_155063_, BlockState p_155064_) {
            SafeBlockEntity.this.playSound(p_155064_, ModSounds.SAFE_OPEN);
            SafeBlockEntity.this.updateBlockState(p_155064_, true);
        }

        protected void m_142289_(Level p_155072_, BlockPos p_155073_, BlockState p_155074_) {
            SafeBlockEntity.this.playSound(p_155074_, ModSounds.SAFE_CLOSE);
            SafeBlockEntity.this.updateBlockState(p_155074_, false);
        }

        protected void m_142148_(Level p_155066_, BlockPos p_155067_, BlockState p_155068_, int p_155069_, int p_155070_) {
        }

        protected boolean m_142718_(Player p_155060_) {
            if (p_155060_.f_36096_ instanceof ChestMenu) {
                Container container = ((ChestMenu)p_155060_.f_36096_).m_39261_();
                return container == SafeBlockEntity.this;
            }
            return false;
        }
    };

    public SafeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SAFE_BLOCK_ENTITY.get(), pos, state);
        this.lockId = UUID.randomUUID();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.m_59634_(tag)) {
            ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        }
        tag.m_128362_("LockId", this.lockId);
        tag.m_128379_("Locked", this.locked);
        tag.m_128379_("HasBeenBound", this.hasBeenBound);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(tag)) {
            ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        }
        this.lockId = tag.m_128342_("LockId");
        this.locked = tag.m_128471_("Locked");
        this.hasBeenBound = tag.m_128471_("HasBeenBound");
    }

    public int m_6643_() {
        return 27;
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> newItems) {
        this.items = newItems;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"block.cuffed.safe");
    }

    protected AbstractContainerMenu m_6555_(int menuId, Inventory inventory) {
        return ChestMenu.m_39237_((int)menuId, (Inventory)inventory, (Container)this);
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void setLocked(boolean value, Level level, Player player, BlockPos pos) {
        level.m_5594_(null, pos, SoundEvents.f_11745_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
        player.m_5661_((Component)Component.m_237115_((String)("info.lock.toggle_" + (!this.locked ? "on" : "off"))), true);
        this.locked = value;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public UUID getLockId() {
        return this.lockId;
    }

    public boolean hasBeenBound() {
        return this.hasBeenBound;
    }

    public void bind() {
        this.hasBeenBound = true;
    }

    public void resetBinding() {
        this.lockId = UUID.randomUUID();
        this.locked = false;
        this.hasBeenBound = false;
    }

    void updateBlockState(BlockState state, boolean b1) {
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)SafeBlock.OPEN, (Comparable)Boolean.valueOf(b1)), 3);
    }

    void playSound(BlockState state, SoundEvent soundEvent) {
        Vec3i vec3i = ((Direction)state.m_61143_((Property)SafeBlock.FACING)).m_122436_();
        double d0 = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double d1 = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double d2 = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        this.f_58857_.m_6263_((Player)null, d0, d1, d2, soundEvent, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }
}

