/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.api;

import com.lazrproductions.cuffed.blocks.PilloryBlock;
import com.lazrproductions.cuffed.blocks.base.ILockableBlock;
import com.lazrproductions.cuffed.cap.RestrainableCapability;
import com.lazrproductions.cuffed.cap.base.IRestrainableCapability;
import com.lazrproductions.cuffed.client.gui.screen.LockpickingScreen;
import com.lazrproductions.cuffed.entity.PadlockEntity;
import com.lazrproductions.cuffed.init.ModItems;
import com.lazrproductions.cuffed.init.ModStatistics;
import com.lazrproductions.cuffed.init.ModTags;
import com.lazrproductions.cuffed.packet.LockpickBlockPacket;
import com.lazrproductions.cuffed.packet.LockpickLockPacket;
import com.lazrproductions.cuffed.packet.LockpickRestraintPacket;
import com.lazrproductions.cuffed.packet.RestraintEquippedPacket;
import com.lazrproductions.cuffed.packet.RestraintSyncPacket;
import com.lazrproductions.cuffed.packet.RestraintUtilityPacket;
import com.lazrproductions.cuffed.restraints.base.AbstractRestraint;
import com.lazrproductions.cuffed.restraints.base.RestraintType;
import com.lazrproductions.lazrslib.common.network.LazrNetwork;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.server.ServerLifecycleHooks;

public class CuffedAPI {

    public static class Privacy {
    }

    public static class Capabilities {
        public static final ResourceLocation RESTRAINABLE_CAPABILITY_NAME = new ResourceLocation("cuffed", "restrainable");
        public static final Capability<RestrainableCapability> RESTRAINABLE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<RestrainableCapability>(){});

        public static IRestrainableCapability getRestrainableCapability(Player player) {
            return (IRestrainableCapability)player.getCapability(RESTRAINABLE_CAPABILITY).orElseGet(RestrainableCapability::new);
        }
    }

    public static class Lockpicking {
        public static final HashMap<BlockPos, UUID> registeredLocks = new HashMap();

        public static void finishLockpickingLock(boolean wasFailed, int lockId, @Nonnull UUID lockpickerUUID) {
            Level level;
            ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(lockpickerUUID);
            if (player != null && (level = player.m_9236_()) != null && !level.m_5776_()) {
                ItemStack itemstack = player.m_21120_(InteractionHand.MAIN_HAND);
                player.m_36335_().m_41524_((Item)ModItems.LOCKPICK.get(), 20);
                if (wasFailed) {
                    itemstack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
                    player.m_36220_((ResourceLocation)ModStatistics.LOCKPICKS_BROKEN.get());
                } else {
                    level.m_7785_((double)((float)player.m_20182_().f_82479_), (double)((float)player.m_20182_().f_82480_), (double)((float)player.m_20182_().f_82481_), SoundEvents.f_11794_, SoundSource.PLAYERS, 1.0f, 1.0f, true);
                    itemstack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
                    Entity entity = level.m_6815_(lockId);
                    if (entity instanceof PadlockEntity) {
                        PadlockEntity e = (PadlockEntity)entity;
                        player.m_36220_((ResourceLocation)ModStatistics.SUCCESSFUL_LOCKPICKS.get());
                        e.RemoveLock();
                    }
                }
            }
        }

        public static void finishLockpickingRestraint(boolean wasFailed, RestraintType restraintType, @Nonnull UUID restrainedPlayerUUID, @Nonnull UUID lockpickerUUID) {
            Level level;
            ServerPlayer lockpicker = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(lockpickerUUID);
            ServerPlayer restrained = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(restrainedPlayerUUID);
            if (lockpicker != null && restrained != null && (level = lockpicker.m_9236_()) != null && !level.m_5776_()) {
                ItemStack itemstack = lockpicker.m_21120_(InteractionHand.MAIN_HAND);
                lockpicker.m_36335_().m_41524_((Item)ModItems.LOCKPICK.get(), 20);
                if (wasFailed) {
                    itemstack.m_41622_(1, (LivingEntity)lockpicker, p -> p.m_21190_(InteractionHand.MAIN_HAND));
                    lockpicker.m_36220_((ResourceLocation)ModStatistics.LOCKPICKS_BROKEN.get());
                } else {
                    level.m_7785_((double)((float)restrained.m_20182_().f_82479_), (double)((float)restrained.m_20182_().f_82480_), (double)((float)restrained.m_20182_().f_82481_), SoundEvents.f_11794_, SoundSource.PLAYERS, 1.0f, 1.0f, true);
                    itemstack.m_41622_(1, (LivingEntity)lockpicker, p -> p.m_21190_(InteractionHand.MAIN_HAND));
                    lockpicker.m_36220_((ResourceLocation)ModStatistics.SUCCESSFUL_LOCKPICKS.get());
                    RestrainableCapability cap = (RestrainableCapability)Capabilities.getRestrainableCapability((Player)restrained);
                    cap.TryUnequipRestraint(restrained, lockpicker, restraintType);
                }
            }
        }

        public static void finishLockpickingCellDoor(boolean wasFailed, @Nonnull BlockPos pos, UUID lockpickerUUID) {
            Level level;
            ServerPlayer lockpicker = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(lockpickerUUID);
            if (lockpicker != null && (level = lockpicker.m_9236_()) != null && !level.m_5776_()) {
                ItemStack itemstack = lockpicker.m_21120_(InteractionHand.MAIN_HAND);
                lockpicker.m_36335_().m_41524_((Item)ModItems.LOCKPICK.get(), 20);
                if (wasFailed) {
                    itemstack.m_41622_(1, (LivingEntity)lockpicker, p -> p.m_21190_(InteractionHand.MAIN_HAND));
                    lockpicker.m_36220_((ResourceLocation)ModStatistics.LOCKPICKS_BROKEN.get());
                } else {
                    level.m_7785_((double)((float)lockpicker.m_20182_().f_82479_), (double)((float)lockpicker.m_20182_().f_82480_), (double)((float)lockpicker.m_20182_().f_82481_), SoundEvents.f_11794_, SoundSource.PLAYERS, 1.0f, 1.0f, true);
                    lockpicker.m_36220_((ResourceLocation)ModStatistics.SUCCESSFUL_LOCKPICKS.get());
                    itemstack.m_41622_(1, (LivingEntity)lockpicker, p -> p.m_21190_(InteractionHand.MAIN_HAND));
                    level.m_46961_(pos, true);
                }
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public static void beginLockpickingLock(@Nonnull Minecraft instance, int lockId, int speedIncreasePerPhase, int progressPerPick) {
            LockpickingScreen overlay = new LockpickingScreen(instance);
            overlay.speedIncreasePerPhase = speedIncreasePerPhase;
            overlay.progressPerPick = progressPerPick;
            overlay.type = 0;
            overlay.lockId = lockId;
            instance.m_91152_((Screen)overlay);
        }

        @OnlyIn(value=Dist.CLIENT)
        public static void beginLockpickingRestraint(@Nonnull Minecraft instance, String restrainedUUID, int restraintType, int speedIncreasePerPhase, int progressPerPick) {
            LockpickingScreen overlay = new LockpickingScreen(instance);
            overlay.speedIncreasePerPhase = speedIncreasePerPhase;
            overlay.progressPerPick = progressPerPick;
            overlay.type = 1;
            overlay.restrainedUUID = restrainedUUID;
            overlay.restraintType = restraintType;
            instance.m_91152_((Screen)overlay);
        }

        @OnlyIn(value=Dist.CLIENT)
        public static void beginLockpickingCellDoor(@Nonnull Minecraft instance, BlockPos pos, int speedIncreasePerPhase, int progressPerPick) {
            LockpickingScreen overlay = new LockpickingScreen(instance);
            overlay.speedIncreasePerPhase = speedIncreasePerPhase;
            overlay.progressPerPick = progressPerPick;
            overlay.type = 2;
            overlay.doorPos = pos;
            instance.m_91152_((Screen)overlay);
        }

        public static boolean isLockedAt(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockPos pos) {
            boolean isLockedBlock = false;
            if (state.m_204336_(ModTags.Blocks.LOCKABLE_BLOCKS)) {
                PadlockEntity eA;
                Object eB;
                Block block;
                PadlockEntity padlock = PadlockEntity.getLockAt(level, pos);
                if (padlock != null && padlock.isLocked()) {
                    isLockedBlock = true;
                }
                if (state.m_60734_() instanceof ILockableBlock && ILockableBlock.isLocked(state)) {
                    isLockedBlock = true;
                }
                if ((block = state.m_60734_()) instanceof DoorBlock) {
                    DoorBlock door = (DoorBlock)block;
                    eB = PadlockEntity.getLockAt(level, pos.m_7495_());
                    eA = PadlockEntity.getLockAt(level, pos.m_7494_());
                    if (level.m_8055_(pos.m_7495_()).m_60713_((Block)door) && eB != null && ((PadlockEntity)((Object)eB)).isLocked()) {
                        isLockedBlock = true;
                    } else if (level.m_8055_(pos.m_7494_()).m_60713_((Block)door) && eA != null && eA.isLocked()) {
                        isLockedBlock = true;
                    }
                }
                if ((eB = state.m_60734_()) instanceof PilloryBlock) {
                    PilloryBlock pillory = (PilloryBlock)((Object)eB);
                    eB = PadlockEntity.getLockAt(level, pos.m_7495_());
                    eA = PadlockEntity.getLockAt(level, pos.m_7494_());
                    if (level.m_8055_(pos.m_7495_()).m_60713_((Block)pillory) && eB != null && ((PadlockEntity)((Object)eB)).isLocked()) {
                        isLockedBlock = true;
                    } else if (level.m_8055_(pos.m_7494_()).m_60713_((Block)pillory) && eA != null && eA.isLocked()) {
                        isLockedBlock = true;
                    }
                }
                if (state.m_60734_() instanceof ChestBlock) {
                    Direction dir = ChestBlock.m_51584_((BlockState)state);
                    BlockPos otherPos = pos.m_121945_(dir);
                    PadlockEntity otherPadlock = PadlockEntity.getLockAt(level, otherPos);
                    if (level.m_8055_(otherPos).m_60713_(Blocks.f_50087_) && otherPadlock != null && otherPadlock.isLocked()) {
                        isLockedBlock = true;
                    }
                }
            }
            return isLockedBlock;
        }

        public static void loadWorld() {
            registeredLocks.clear();
        }

        public static void saveWorld() {
        }
    }

    public static class Networking {
        public static final LazrNetwork NETWORK = new LazrNetwork(new ResourceLocation("cuffed", "main"), 1);

        public static void sendRestraintSyncPacket(@Nonnull ServerPlayer client) {
            IRestrainableCapability cap = Capabilities.getRestrainableCapability((Player)client);
            RestraintSyncPacket packet = new RestraintSyncPacket(client.m_19879_(), client.m_20148_().toString(), cap.serializeNBT());
            NETWORK.sendTo((Object)packet, client);
        }

        public static void sendRestraintEquipPacket(@Nonnull ServerPlayer client, @Nullable ServerPlayer captor, RestraintType type, @Nullable AbstractRestraint newRestraint, @Nullable AbstractRestraint oldRestraint) {
            RestraintEquippedPacket packet = new RestraintEquippedPacket(client.m_19879_(), client.m_20148_().toString(), type, oldRestraint != null ? oldRestraint.serializeNBT() : null, newRestraint != null ? newRestraint.serializeNBT() : null, captor != null ? captor.m_20148_().toString() : "null");
            NETWORK.sendTo((Object)packet, client);
        }

        public static void sendRestraintUtilityPacketToClient(ServerPlayer client, RestraintType restraintType, int utiltiyCode, int integerArg, boolean booleanArg, double doubleArg, String stringArg) {
            RestraintUtilityPacket packet = new RestraintUtilityPacket(restraintType.toInteger(), utiltiyCode, integerArg, booleanArg, doubleArg, stringArg);
            NETWORK.sendTo((Object)packet, client);
        }

        public static void sendRestraintUtilityPacketToServer(RestraintType restraintType, int utiltiyCode, int integerArg, boolean booleanArg, double doubleArg, String stringArg) {
            RestraintUtilityPacket packet = new RestraintUtilityPacket(restraintType.toInteger(), utiltiyCode, integerArg, booleanArg, doubleArg, stringArg);
            NETWORK.sendToServer((Object)packet);
        }

        public static void sendLockpickFinishPickingLockPacketToServer(boolean wasFailed, int lockId, UUID playerUUID) {
            LockpickLockPacket packet = new LockpickLockPacket(wasFailed, lockId, playerUUID.toString());
            NETWORK.sendToServer((Object)packet);
        }

        public static void sendLockpickFinishPickingRestraintPacketToServer(boolean wasFailed, String restrainedUUID, int restraintType, UUID playerUUID) {
            LockpickRestraintPacket packet = new LockpickRestraintPacket(wasFailed, restrainedUUID, restraintType, playerUUID.toString());
            NETWORK.sendToServer((Object)packet);
        }

        public static void sendLockpickFinishPickingCellDoorPacketToServer(boolean wasFailed, BlockPos pos, UUID playerUUID) {
            LockpickBlockPacket packet = new LockpickBlockPacket(wasFailed, pos, playerUUID.toString());
            NETWORK.sendToServer((Object)packet);
        }

        public static void sendLockpickBeginPickingLockPacketToClient(@Nonnull ServerPlayer player, int lockId, int speedIncreasePerPhase, int progressPerPick) {
            LockpickLockPacket packet = new LockpickLockPacket(lockId, speedIncreasePerPhase, progressPerPick, player.m_20148_().toString());
            NETWORK.sendTo((Object)packet, player);
        }

        public static void sendLockpickBeginPickingRestraintPacketToClient(@Nonnull ServerPlayer player, String restrainedUUID, int restraintType, int speedIncreasePerPhase, int progressPerPick) {
            LockpickRestraintPacket packet = new LockpickRestraintPacket(restrainedUUID, restraintType, speedIncreasePerPhase, progressPerPick, player.m_20148_().toString());
            NETWORK.sendTo((Object)packet, player);
        }

        public static void sendLockpickBeginPickingCellDoorPacketToClient(@Nonnull ServerPlayer player, BlockPos pos, int speedIncreasePerPhase, int progressPerPick) {
            LockpickBlockPacket packet = new LockpickBlockPacket(pos, speedIncreasePerPhase, progressPerPick, player.m_20148_().toString());
            NETWORK.sendTo((Object)packet, player);
        }

        public static void registerPackets() {
            NETWORK.registerPacket(LockpickLockPacket.class, LockpickLockPacket::new);
            NETWORK.registerPacket(LockpickRestraintPacket.class, LockpickRestraintPacket::new);
            NETWORK.registerPacket(LockpickBlockPacket.class, LockpickBlockPacket::new);
            NETWORK.registerPacket(RestraintSyncPacket.class, RestraintSyncPacket::new);
            NETWORK.registerPacket(RestraintEquippedPacket.class, RestraintEquippedPacket::new);
            NETWORK.registerPacket(RestraintUtilityPacket.class, RestraintUtilityPacket::new);
        }
    }
}

