/*
 * Decompiled with CFR 0.152.
 */
package com.wulian.chatimpressiveanimation.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.Message;
import com.wulian.chatimpressiveanimation.config.ConfigUtil;
import com.wulian.chatimpressiveanimation.mixin.ChatHudAccessor;
import com.wulian.chatimpressiveanimation.mixin.ChatHudLineAccessor;
import java.util.List;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChatScreen.class})
public class ChatScreenMixin {
    @Unique
    private boolean wasOpenedLastFrame = false;
    @Unique
    private boolean isClosing = false;
    @Unique
    private long animationStartTime = 0L;
    @Unique
    private float offsetY = 0.0f;
    private static final int FADE_TIME = ConfigUtil.getConfig().chatBarAnimationFadeTime;
    private static final float FADE_OFFSET = 10.0f;
    private static final float EASE_IN_OUT_FACTOR = 1.70158f;
    private static final float EASE_OUT_FACTOR = 2.70158f;
    public final Minecraft client = Minecraft.m_91087_();

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void render(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (!ConfigUtil.getConfig().enableChatBarAnimation) {
            return;
        }
        if (this.client.f_91074_ != null && !this.wasOpenedLastFrame && !this.client.f_91074_.m_5803_()) {
            this.wasOpenedLastFrame = true;
            this.animationStartTime = System.currentTimeMillis();
            this.isClosing = false;
        }
        float screenFactor = (float)this.client.m_91268_().m_85444_() / 1080.0f;
        float elapsedTime = System.currentTimeMillis() - this.animationStartTime;
        float alpha = this.isClosing ? elapsedTime / (float)FADE_TIME : 1.0f - elapsedTime / (float)FADE_TIME;
        alpha = Math.min(1.0f, Math.max(0.0f, alpha));
        float easedAlpha = 2.70158f * alpha * alpha * alpha - 1.70158f * alpha * alpha;
        this.offsetY = easedAlpha * 10.0f * screenFactor;
        if (this.isClosing) {
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - easedAlpha));
        }
        context.m_280168_().m_85836_();
        context.m_280168_().m_252880_(0.0f, this.offsetY, 0.0f);
    }

    @Unique
    private boolean hasActiveChatMessages() {
        if (this.client.f_91065_ == null || this.client.f_91065_.m_93076_() == null) {
            return false;
        }
        List<Message> messages = ((ChatHudAccessor)this.client.f_91065_.m_93076_()).getVisibleMessages();
        int ticks = this.client.f_91065_.m_93079_();
        int fadeTicks = 200;
        for (Message msg : messages) {
            GuiMessage line;
            int creationTick;
            if (!(msg instanceof GuiMessage) || ticks - (creationTick = ((ChatHudLineAccessor)(line = (GuiMessage)msg)).getCreationTick()) >= 200) continue;
            return true;
        }
        return false;
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void onKeyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (keyCode == 256) {
            if (ConfigUtil.getConfig().enableChatBarAnimation && !this.hasActiveChatMessages()) {
                this.isClosing = true;
                this.animationStartTime = System.currentTimeMillis();
            } else {
                this.client.m_91152_(null);
            }
            cir.cancel();
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void renderEnd(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (!ConfigUtil.getConfig().enableChatBarAnimation) {
            return;
        }
        context.m_280168_().m_85849_();
        if (this.isClosing) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }
        if (this.isClosing && System.currentTimeMillis() - this.animationStartTime >= (long)FADE_TIME) {
            this.client.m_91152_(null);
        }
    }
}

