/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class ArmorItem
extends Item
implements Equipable {
    private static final EnumMap<Type, UUID> f_265987_ = Util.m_137469_(new EnumMap(Type.class), p_266744_ -> {
        p_266744_.put(Type.BOOTS, UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"));
        p_266744_.put(Type.LEGGINGS, UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"));
        p_266744_.put(Type.CHESTPLATE, UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"));
        p_266744_.put(Type.HELMET, UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150"));
    });
    public static final DispenseItemBehavior f_40376_ = new DefaultDispenseItemBehavior(){

        protected ItemStack m_7498_(BlockSource p_40408_, ItemStack p_40409_) {
            return ArmorItem.m_40398_(p_40408_, p_40409_) ? p_40409_ : super.m_7498_(p_40408_, p_40409_);
        }
    };
    protected final Type f_265916_;
    private final int f_40381_;
    private final float f_40382_;
    protected final float f_40378_;
    protected final ArmorMaterial f_40379_;
    private final Multimap<Attribute, AttributeModifier> f_40383_;

    public static boolean m_40398_(BlockSource p_40399_, ItemStack p_40400_) {
        BlockPos blockpos = p_40399_.m_7961_().m_121945_((Direction)p_40399_.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
        List list = p_40399_.m_7727_().m_6443_(LivingEntity.class, new AABB(blockpos), EntitySelector.f_20408_.and(new EntitySelector.MobCanWearArmorEntitySelector(p_40400_)));
        if (list.isEmpty()) {
            return false;
        }
        LivingEntity livingentity = (LivingEntity)((Object)list.get(0));
        EquipmentSlot equipmentslot = Mob.m_147233_(p_40400_);
        ItemStack itemstack = p_40400_.m_41620_(1);
        livingentity.m_8061_(equipmentslot, itemstack);
        if (livingentity instanceof Mob) {
            ((Mob)livingentity).m_21409_(equipmentslot, 2.0f);
            ((Mob)livingentity).m_21530_();
        }
        return true;
    }

    public ArmorItem(ArmorMaterial p_40386_, Type p_266831_, Item.Properties p_40388_) {
        super(p_40388_.m_41499_(p_40386_.m_266425_(p_266831_)));
        this.f_40379_ = p_40386_;
        this.f_265916_ = p_266831_;
        this.f_40381_ = p_40386_.m_7366_(p_266831_);
        this.f_40382_ = p_40386_.m_6651_();
        this.f_40378_ = p_40386_.m_6649_();
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)f_40376_);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = f_265987_.get((Object)p_266831_);
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)this.f_40381_, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor toughness", (double)this.f_40382_, AttributeModifier.Operation.ADDITION));
        if (this.f_40378_ > 0.0f) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Armor knockback resistance", (double)this.f_40378_, AttributeModifier.Operation.ADDITION));
        }
        this.f_40383_ = builder.build();
    }

    public Type m_266204_() {
        return this.f_265916_;
    }

    @Override
    public int m_6473_() {
        return this.f_40379_.m_6646_();
    }

    public ArmorMaterial m_40401_() {
        return this.f_40379_;
    }

    @Override
    public boolean m_6832_(ItemStack p_40392_, ItemStack p_40393_) {
        return this.f_40379_.m_6230_().test(p_40393_) || super.m_6832_(p_40392_, p_40393_);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level p_40395_, Player p_40396_, InteractionHand p_40397_) {
        return this.m_269277_(this, p_40395_, p_40396_, p_40397_);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot p_40390_) {
        return p_40390_ == this.f_265916_.m_266308_() ? this.f_40383_ : super.m_7167_(p_40390_);
    }

    public int m_40404_() {
        return this.f_40381_;
    }

    public float m_40405_() {
        return this.f_40382_;
    }

    public EquipmentSlot m_40402_() {
        return this.f_265916_.m_266308_();
    }

    public SoundEvent m_150681_() {
        return this.m_40401_().m_7344_();
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type HELMET = new Type(EquipmentSlot.HEAD, "helmet");
        public static final /* enum */ Type CHESTPLATE = new Type(EquipmentSlot.CHEST, "chestplate");
        public static final /* enum */ Type LEGGINGS = new Type(EquipmentSlot.LEGS, "leggings");
        public static final /* enum */ Type BOOTS = new Type(EquipmentSlot.FEET, "boots");
        private final EquipmentSlot f_265980_;
        private final String f_266116_;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String p_267127_) {
            return Enum.valueOf(Type.class, p_267127_);
        }

        private Type(EquipmentSlot p_266754_, String p_266886_) {
            this.f_265980_ = p_266754_;
            this.f_266116_ = p_266886_;
        }

        public EquipmentSlot m_266308_() {
            return this.f_265980_;
        }

        public String m_266355_() {
            return this.f_266116_;
        }

        private static /* synthetic */ Type[] m_266245_() {
            return new Type[]{HELMET, CHESTPLATE, LEGGINGS, BOOTS};
        }

        static {
            $VALUES = Type.m_266245_();
        }
    }
}

