/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.serialization.Lifecycle;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.ForgeHooks;

public class RegistrySetBuilder {
    private final List<RegistryStub<?>> f_254732_ = new ArrayList();

    static <T> HolderGetter<T> m_254882_(HolderLookup.RegistryLookup<T> p_255625_) {
        return new EmptyTagLookup<T>((HolderOwner)p_255625_, (HolderLookup.RegistryLookup)p_255625_){
            final /* synthetic */ HolderLookup.RegistryLookup val$p_255625_;
            {
                this.val$p_255625_ = registryLookup;
                super(p_256158_);
            }

            public Optional<Holder.Reference<T>> m_254902_(ResourceKey<T> p_255765_) {
                return this.val$p_255625_.m_254902_(p_255765_);
            }
        };
    }

    public <T> RegistrySetBuilder m_255162_(ResourceKey<? extends Registry<T>> p_256446_, Lifecycle p_256394_, RegistryBootstrap<T> p_256638_) {
        this.f_254732_.add(new RegistryStub<T>(p_256446_, p_256394_, p_256638_));
        return this;
    }

    public <T> RegistrySetBuilder m_254916_(ResourceKey<? extends Registry<T>> p_256261_, RegistryBootstrap<T> p_256010_) {
        return this.m_255162_(p_256261_, Lifecycle.stable(), p_256010_);
    }

    public List<? extends ResourceKey<? extends Registry<?>>> getEntryKeys() {
        return this.f_254732_.stream().map(RegistryStub::f_254738_).toList();
    }

    private BuildState m_254900_(RegistryAccess p_256400_) {
        BuildState registrysetbuilder$buildstate = BuildState.m_255369_(p_256400_, this.f_254732_.stream().map(RegistryStub::f_254738_));
        this.f_254732_.forEach(p_255629_ -> p_255629_.m_254946_(registrysetbuilder$buildstate));
        return registrysetbuilder$buildstate;
    }

    public HolderLookup.Provider m_255144_(RegistryAccess p_256112_) {
        BuildState registrysetbuilder$buildstate = this.m_254900_(p_256112_);
        Stream<HolderLookup.RegistryLookup> stream = p_256112_.m_206193_().map(p_258195_ -> p_258195_.f_206234_().m_255303_());
        Stream<HolderLookup.RegistryLookup> stream1 = this.f_254732_.stream().map(p_255700_ -> p_255700_.m_254914_(registrysetbuilder$buildstate).m_254889_());
        HolderLookup.Provider holderlookup$provider = HolderLookup.Provider.m_254973_(Stream.concat(stream, stream1.peek(registrysetbuilder$buildstate::m_254987_)));
        registrysetbuilder$buildstate.m_255228_();
        registrysetbuilder$buildstate.m_255178_();
        return holderlookup$provider;
    }

    public HolderLookup.Provider m_254929_(RegistryAccess p_255676_, HolderLookup.Provider p_255900_) {
        BuildState registrysetbuilder$buildstate = this.m_254900_(p_255676_);
        HashMap map = new HashMap();
        registrysetbuilder$buildstate.m_272134_().forEach(p_272339_ -> map.put(p_272339_.f_271195_, p_272339_));
        this.f_254732_.stream().map(p_272337_ -> p_272337_.m_254914_(registrysetbuilder$buildstate)).forEach(p_272341_ -> map.put(p_272341_.f_271195_, p_272341_));
        Stream<HolderLookup.RegistryLookup> stream = p_255676_.m_206193_().map(p_258194_ -> p_258194_.f_206234_().m_255303_());
        HolderLookup.Provider holderlookup$provider = HolderLookup.Provider.m_254973_(Stream.concat(stream, map.values().stream().map(RegistryContents::m_254889_).peek(registrysetbuilder$buildstate::m_254987_)));
        registrysetbuilder$buildstate.m_255298_(p_255900_);
        registrysetbuilder$buildstate.m_255228_();
        registrysetbuilder$buildstate.m_255178_();
        return holderlookup$provider;
    }

    record RegistryStub<T>(ResourceKey<? extends Registry<T>> f_254738_, Lifecycle f_254728_, RegistryBootstrap<T> f_254689_) {
        void m_254946_(BuildState p_256272_) {
            this.f_254689_.m_254966_(p_256272_.m_255274_());
        }

        public RegistryContents<T> m_254914_(BuildState p_256416_) {
            HashMap map = new HashMap();
            Iterator<Map.Entry<ResourceKey<?>, RegisteredValue<?>>> iterator = p_256416_.f_254644_.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceKey<?>, RegisteredValue<?>> entry = iterator.next();
                ResourceKey<?> resourcekey = entry.getKey();
                if (!resourcekey.m_135783_(this.f_254738_)) continue;
                RegisteredValue<?> registeredvalue = entry.getValue();
                Holder.Reference<Object> reference = p_256416_.f_254749_.f_254730_.remove(resourcekey);
                map.put(resourcekey, new ValueAndHolder(registeredvalue, Optional.ofNullable(reference)));
                iterator.remove();
            }
            return new RegistryContents(this.f_254738_, this.f_254728_, map);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RegistryStub.class, "key;lifecycle;bootstrap", "f_254738_", "f_254728_", "f_254689_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RegistryStub.class, "key;lifecycle;bootstrap", "f_254738_", "f_254728_", "f_254689_"}, this);
        }

        @Override
        public final boolean equals(Object p_256621_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RegistryStub.class, "key;lifecycle;bootstrap", "f_254738_", "f_254728_", "f_254689_"}, this, p_256621_);
        }
    }

    @FunctionalInterface
    public static interface RegistryBootstrap<T> {
        public void m_254966_(BootstapContext<T> var1);
    }

    record BuildState(CompositeOwner f_254680_, UniversalLookup f_254749_, Map<ResourceLocation, HolderGetter<?>> f_254690_, Map<ResourceKey<?>, RegisteredValue<?>> f_254644_, List<RuntimeException> f_254627_) {
        public static BuildState m_255369_(RegistryAccess p_255995_, Stream<ResourceKey<? extends Registry<?>>> p_256495_) {
            CompositeOwner registrysetbuilder$compositeowner = new CompositeOwner();
            ArrayList<RuntimeException> list = new ArrayList<RuntimeException>();
            UniversalLookup registrysetbuilder$universallookup = new UniversalLookup(registrysetbuilder$compositeowner);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            p_255995_.m_206193_().forEach(p_258197_ -> builder.put((Object)p_258197_.f_206233_().m_135782_(), (Object)ForgeHooks.wrapRegistryLookup((HolderLookup.RegistryLookup)p_258197_.f_206234_().m_255303_())));
            p_256495_.forEach(p_256603_ -> builder.put((Object)p_256603_.m_135782_(), (Object)registrysetbuilder$universallookup));
            return new BuildState(registrysetbuilder$compositeowner, registrysetbuilder$universallookup, (Map<ResourceLocation, HolderGetter<?>>)builder.build(), new HashMap(), (List<RuntimeException>)list);
        }

        public <T> BootstapContext<T> m_255274_() {
            return new BootstapContext<T>(){

                @Override
                public Holder.Reference<T> m_255042_(ResourceKey<T> p_256176_, T p_256422_, Lifecycle p_255924_) {
                    RegisteredValue registeredvalue = f_254644_.put(p_256176_, new RegisteredValue(p_256422_, p_255924_));
                    if (registeredvalue != null) {
                        f_254627_.add(new IllegalStateException("Duplicate registration for " + String.valueOf(p_256176_) + ", new=" + String.valueOf(p_256422_) + ", old=" + String.valueOf(registeredvalue.f_254685_)));
                    }
                    return f_254749_.m_255345_(p_256176_);
                }

                @Override
                public <S> HolderGetter<S> m_255420_(ResourceKey<? extends Registry<? extends S>> p_255961_) {
                    return f_254690_.getOrDefault(p_255961_.m_135782_(), f_254749_);
                }

                @Override
                public <S> Optional<HolderLookup.RegistryLookup<S>> registryLookup(ResourceKey<? extends Registry<? extends S>> registry) {
                    return Optional.ofNullable((HolderLookup.RegistryLookup)f_254690_.get(registry.m_135782_()));
                }
            };
        }

        public void m_255228_() {
            for (ResourceKey<Object> resourcekey : this.f_254749_.f_254730_.keySet()) {
                this.f_254627_.add(new IllegalStateException("Unreferenced key: " + String.valueOf(resourcekey)));
            }
            this.f_254644_.forEach((p_256143_, p_256662_) -> this.f_254627_.add(new IllegalStateException("Orpaned value " + String.valueOf(p_256662_.f_254685_) + " for key " + String.valueOf(p_256143_))));
        }

        public void m_255178_() {
            if (!this.f_254627_.isEmpty()) {
                IllegalStateException illegalstateexception = new IllegalStateException("Errors during registry creation");
                for (RuntimeException runtimeexception : this.f_254627_) {
                    illegalstateexception.addSuppressed(runtimeexception);
                }
                throw illegalstateexception;
            }
        }

        public void m_254987_(HolderOwner<?> p_256407_) {
            this.f_254680_.m_255436_(p_256407_);
        }

        public void m_255298_(HolderLookup.Provider p_255679_) {
            HashMap<ResourceLocation, Optional> map = new HashMap<ResourceLocation, Optional>();
            Iterator<Map.Entry<ResourceKey<Object>, Holder.Reference<Object>>> iterator = this.f_254749_.f_254730_.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceKey<Object>, Holder.Reference<Object>> entry = iterator.next();
                ResourceKey<Object> resourcekey = entry.getKey();
                Holder.Reference<Object> reference = entry.getValue();
                map.computeIfAbsent(resourcekey.m_211136_(), p_255896_ -> p_255679_.m_254861_(ResourceKey.m_135788_(p_255896_))).flatMap(p_256068_ -> p_256068_.m_254902_(resourcekey)).ifPresent(p_256030_ -> {
                    reference.m_247654_(p_256030_.m_203334_());
                    iterator.remove();
                });
            }
        }

        public Stream<RegistryContents<?>> m_272134_() {
            return this.f_254749_.f_254730_.keySet().stream().map(ResourceKey::m_211136_).distinct().map(p_272342_ -> new RegistryContents(ResourceKey.m_135788_(p_272342_), Lifecycle.stable(), Map.of()));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BuildState.class, "owner;lookup;registries;registeredValues;errors", "f_254680_", "f_254749_", "f_254690_", "f_254644_", "f_254627_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BuildState.class, "owner;lookup;registries;registeredValues;errors", "f_254680_", "f_254749_", "f_254690_", "f_254644_", "f_254627_"}, this);
        }

        @Override
        public final boolean equals(Object p_256666_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BuildState.class, "owner;lookup;registries;registeredValues;errors", "f_254680_", "f_254749_", "f_254690_", "f_254644_", "f_254627_"}, this, p_256666_);
        }
    }

    record RegistryContents<T>(ResourceKey<? extends Registry<? extends T>> f_271195_, Lifecycle f_271144_, Map<ResourceKey<T>, ValueAndHolder<T>> f_254715_) {
        public HolderLookup.RegistryLookup<T> m_254889_() {
            return new HolderLookup.RegistryLookup<T>(){
                private final Map<ResourceKey<T>, Holder.Reference<T>> f_254643_;
                {
                    this.f_254643_ = f_254715_.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, p_256193_ -> {
                        ValueAndHolder valueandholder = (ValueAndHolder)p_256193_.getValue();
                        Holder.Reference reference = valueandholder.f_254632_().orElseGet(() -> Holder.Reference.m_254896_(this, (ResourceKey)p_256193_.getKey()));
                        reference.m_247654_(valueandholder.f_254683_().f_254685_());
                        return reference;
                    }));
                }

                public ResourceKey<? extends Registry<? extends T>> m_254879_() {
                    return f_271195_;
                }

                public Lifecycle m_254883_() {
                    return f_271144_;
                }

                public Optional<Holder.Reference<T>> m_254902_(ResourceKey<T> p_255760_) {
                    return Optional.ofNullable(this.f_254643_.get(p_255760_));
                }

                public Stream<Holder.Reference<T>> m_214062_() {
                    return this.f_254643_.values().stream();
                }

                public Optional<HolderSet.Named<T>> m_254901_(TagKey<T> p_255810_) {
                    return Optional.empty();
                }

                public Stream<HolderSet.Named<T>> m_214063_() {
                    return Stream.empty();
                }
            };
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RegistryContents.class, "key;lifecycle;values", "f_271195_", "f_271144_", "f_254715_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RegistryContents.class, "key;lifecycle;values", "f_271195_", "f_271144_", "f_254715_"}, this);
        }

        @Override
        public final boolean equals(Object p_255967_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RegistryContents.class, "key;lifecycle;values", "f_271195_", "f_271144_", "f_254715_"}, this, p_255967_);
        }
    }

    record ValueAndHolder<T>(RegisteredValue<T> f_254683_, Optional<Holder.Reference<T>> f_254632_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ValueAndHolder.class, "value;holder", "f_254683_", "f_254632_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ValueAndHolder.class, "value;holder", "f_254683_", "f_254632_"}, this);
        }

        @Override
        public final boolean equals(Object p_256656_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ValueAndHolder.class, "value;holder", "f_254683_", "f_254632_"}, this, p_256656_);
        }
    }

    static class UniversalLookup
    extends EmptyTagLookup<Object> {
        final Map<ResourceKey<Object>, Holder.Reference<Object>> f_254730_ = new HashMap<ResourceKey<Object>, Holder.Reference<Object>>();

        public UniversalLookup(HolderOwner<Object> p_256629_) {
            super(p_256629_);
        }

        public Optional<Holder.Reference<Object>> m_254902_(ResourceKey<Object> p_256303_) {
            return Optional.of(this.m_255345_(p_256303_));
        }

        <T> Holder.Reference<T> m_255345_(ResourceKey<T> p_256298_) {
            return this.f_254730_.computeIfAbsent(p_256298_, p_256154_ -> Holder.Reference.m_254896_(this.f_254742_, p_256154_));
        }
    }

    record RegisteredValue<T>(T f_254685_, Lifecycle f_254641_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RegisteredValue.class, "value;lifecycle", "f_254685_", "f_254641_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RegisteredValue.class, "value;lifecycle", "f_254685_", "f_254641_"}, this);
        }

        @Override
        public final boolean equals(Object p_255671_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RegisteredValue.class, "value;lifecycle", "f_254685_", "f_254641_"}, this, p_255671_);
        }
    }

    static abstract class EmptyTagLookup<T>
    implements HolderGetter<T> {
        protected final HolderOwner<T> f_254742_;

        protected EmptyTagLookup(HolderOwner<T> p_256166_) {
            this.f_254742_ = p_256166_;
        }

        public Optional<HolderSet.Named<T>> m_254901_(TagKey<T> p_256664_) {
            return Optional.of(HolderSet.m_255229_(this.f_254742_, p_256664_));
        }
    }

    static class CompositeOwner
    implements HolderOwner<Object> {
        private final Set<HolderOwner<?>> f_254663_ = Sets.newIdentityHashSet();

        CompositeOwner() {
        }

        public boolean m_254921_(HolderOwner<Object> p_256333_) {
            return this.f_254663_.contains(p_256333_);
        }

        public void m_255436_(HolderOwner<?> p_256361_) {
            this.f_254663_.add(p_256361_);
        }
    }
}

