/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IArmPoseTransformer;
import net.minecraftforge.common.IExtensibleEnum;

@OnlyIn(value=Dist.CLIENT)
public class HumanoidModel<T extends LivingEntity>
extends AgeableListModel<T>
implements ArmedModel,
HeadedModel {
    public static final float f_170673_ = 0.25f;
    public static final float f_170674_ = 0.5f;
    public static final float f_268570_ = -0.1f;
    private static final float f_268560_ = 0.005f;
    private static final float f_170671_ = 0.2617994f;
    private static final float f_170672_ = 1.9198622f;
    private static final float f_170675_ = 0.2617994f;
    public static final float f_233401_ = 1.4835298f;
    public static final float f_233402_ = 0.5235988f;
    public final ModelPart f_102808_;
    public final ModelPart f_102809_;
    public final ModelPart f_102810_;
    public final ModelPart f_102811_;
    public final ModelPart f_102812_;
    public final ModelPart f_102813_;
    public final ModelPart f_102814_;
    public ArmPose f_102815_ = ArmPose.EMPTY;
    public ArmPose f_102816_ = ArmPose.EMPTY;
    public boolean f_102817_;
    public float f_102818_;

    public HumanoidModel(ModelPart p_170677_) {
        this(p_170677_, RenderType::m_110458_);
    }

    public HumanoidModel(ModelPart p_170679_, Function<ResourceLocation, RenderType> p_170680_) {
        super(p_170680_, true, 16.0f, 0.0f, 2.0f, 2.0f, 24.0f);
        this.f_102808_ = p_170679_.m_171324_("head");
        this.f_102809_ = p_170679_.m_171324_("hat");
        this.f_102810_ = p_170679_.m_171324_("body");
        this.f_102811_ = p_170679_.m_171324_("right_arm");
        this.f_102812_ = p_170679_.m_171324_("left_arm");
        this.f_102813_ = p_170679_.m_171324_("right_leg");
        this.f_102814_ = p_170679_.m_171324_("left_leg");
    }

    public static MeshDefinition m_170681_(CubeDeformation p_170682_, float p_170683_) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, p_170682_), PartPose.m_171419_((float)0.0f, (float)(0.0f + p_170683_), (float)0.0f));
        partdefinition.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, p_170682_.m_171469_(0.5f)), PartPose.m_171419_((float)0.0f, (float)(0.0f + p_170683_), (float)0.0f));
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, p_170682_), PartPose.m_171419_((float)0.0f, (float)(0.0f + p_170683_), (float)0.0f));
        partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.m_171419_((float)-5.0f, (float)(2.0f + p_170683_), (float)0.0f));
        partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.m_171419_((float)5.0f, (float)(2.0f + p_170683_), (float)0.0f));
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.m_171419_((float)-1.9f, (float)(12.0f + p_170683_), (float)0.0f));
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.m_171419_((float)1.9f, (float)(12.0f + p_170683_), (float)0.0f));
        return meshdefinition;
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.f_102808_);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102810_, (Object)this.f_102811_, (Object)this.f_102812_, (Object)this.f_102813_, (Object)this.f_102814_, (Object)this.f_102809_);
    }

    public void m_6839_(T p_102861_, float p_102862_, float p_102863_, float p_102864_) {
        this.f_102818_ = ((LivingEntity)((Object)p_102861_)).m_20998_(p_102864_);
        super.m_6839_(p_102861_, p_102862_, p_102863_, p_102864_);
    }

    public void m_6973_(T p_102866_, float p_102867_, float p_102868_, float p_102869_, float p_102870_, float p_102871_) {
        boolean flag2;
        boolean flag = ((LivingEntity)((Object)p_102866_)).m_21256_() > 4;
        boolean flag1 = ((LivingEntity)((Object)p_102866_)).m_6067_();
        this.f_102808_.f_104204_ = p_102870_ * ((float)Math.PI / 180);
        this.f_102808_.f_104203_ = flag ? -0.7853982f : (this.f_102818_ > 0.0f ? (flag1 ? this.m_102835_(this.f_102818_, this.f_102808_.f_104203_, -0.7853982f) : this.m_102835_(this.f_102818_, this.f_102808_.f_104203_, p_102871_ * ((float)Math.PI / 180))) : p_102871_ * ((float)Math.PI / 180));
        this.f_102810_.f_104204_ = 0.0f;
        this.f_102811_.f_104202_ = 0.0f;
        this.f_102811_.f_104200_ = -5.0f;
        this.f_102812_.f_104202_ = 0.0f;
        this.f_102812_.f_104200_ = 5.0f;
        float f = 1.0f;
        if (flag) {
            f = (float)((Entity)((Object)p_102866_)).m_20184_().m_82556_();
            f /= 0.2f;
            f *= f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.f_102811_.f_104203_ = Mth.m_14089_((float)(p_102867_ * 0.6662f + (float)Math.PI)) * 2.0f * p_102868_ * 0.5f / f;
        this.f_102812_.f_104203_ = Mth.m_14089_((float)(p_102867_ * 0.6662f)) * 2.0f * p_102868_ * 0.5f / f;
        this.f_102811_.f_104205_ = 0.0f;
        this.f_102812_.f_104205_ = 0.0f;
        this.f_102813_.f_104203_ = Mth.m_14089_((float)(p_102867_ * 0.6662f)) * 1.4f * p_102868_ / f;
        this.f_102814_.f_104203_ = Mth.m_14089_((float)(p_102867_ * 0.6662f + (float)Math.PI)) * 1.4f * p_102868_ / f;
        this.f_102813_.f_104204_ = 0.005f;
        this.f_102814_.f_104204_ = -0.005f;
        this.f_102813_.f_104205_ = 0.005f;
        this.f_102814_.f_104205_ = -0.005f;
        if (this.f_102609_) {
            this.f_102811_.f_104203_ += -0.62831855f;
            this.f_102812_.f_104203_ += -0.62831855f;
            this.f_102813_.f_104203_ = -1.4137167f;
            this.f_102813_.f_104204_ = 0.31415927f;
            this.f_102813_.f_104205_ = 0.07853982f;
            this.f_102814_.f_104203_ = -1.4137167f;
            this.f_102814_.f_104204_ = -0.31415927f;
            this.f_102814_.f_104205_ = -0.07853982f;
        }
        this.f_102811_.f_104204_ = 0.0f;
        this.f_102812_.f_104204_ = 0.0f;
        boolean bl = flag2 = ((LivingEntity)((Object)p_102866_)).m_5737_() == HumanoidArm.RIGHT;
        if (((LivingEntity)((Object)p_102866_)).m_6117_()) {
            boolean flag3;
            boolean bl2 = flag3 = ((LivingEntity)((Object)p_102866_)).m_7655_() == InteractionHand.MAIN_HAND;
            if (flag3 == flag2) {
                this.m_102875_(p_102866_);
            } else {
                this.m_102878_(p_102866_);
            }
        } else {
            boolean flag4;
            boolean bl3 = flag4 = flag2 ? this.f_102815_.m_102897_() : this.f_102816_.m_102897_();
            if (flag2 != flag4) {
                this.m_102878_(p_102866_);
                this.m_102875_(p_102866_);
            } else {
                this.m_102875_(p_102866_);
                this.m_102878_(p_102866_);
            }
        }
        this.m_7884_(p_102866_, p_102869_);
        if (this.f_102817_) {
            this.f_102810_.f_104203_ = 0.5f;
            this.f_102811_.f_104203_ += 0.4f;
            this.f_102812_.f_104203_ += 0.4f;
            this.f_102813_.f_104202_ = 4.0f;
            this.f_102814_.f_104202_ = 4.0f;
            this.f_102813_.f_104201_ = 12.2f;
            this.f_102814_.f_104201_ = 12.2f;
            this.f_102808_.f_104201_ = 4.2f;
            this.f_102810_.f_104201_ = 3.2f;
            this.f_102812_.f_104201_ = 5.2f;
            this.f_102811_.f_104201_ = 5.2f;
        } else {
            this.f_102810_.f_104203_ = 0.0f;
            this.f_102813_.f_104202_ = 0.0f;
            this.f_102814_.f_104202_ = 0.0f;
            this.f_102813_.f_104201_ = 12.0f;
            this.f_102814_.f_104201_ = 12.0f;
            this.f_102808_.f_104201_ = 0.0f;
            this.f_102810_.f_104201_ = 0.0f;
            this.f_102812_.f_104201_ = 2.0f;
            this.f_102811_.f_104201_ = 2.0f;
        }
        if (this.f_102816_ != ArmPose.SPYGLASS) {
            AnimationUtils.m_170341_((ModelPart)this.f_102811_, (float)p_102869_, (float)1.0f);
        }
        if (this.f_102815_ != ArmPose.SPYGLASS) {
            AnimationUtils.m_170341_((ModelPart)this.f_102812_, (float)p_102869_, (float)-1.0f);
        }
        if (this.f_102818_ > 0.0f) {
            float f2;
            float f5 = p_102867_ % 26.0f;
            HumanoidArm humanoidarm = this.m_102856_(p_102866_);
            float f1 = humanoidarm == HumanoidArm.RIGHT && this.f_102608_ > 0.0f ? 0.0f : this.f_102818_;
            float f3 = f2 = humanoidarm == HumanoidArm.LEFT && this.f_102608_ > 0.0f ? 0.0f : this.f_102818_;
            if (!((LivingEntity)((Object)p_102866_)).m_6117_()) {
                if (f5 < 14.0f) {
                    this.f_102812_.f_104203_ = this.m_102835_(f2, this.f_102812_.f_104203_, 0.0f);
                    this.f_102811_.f_104203_ = Mth.m_14179_((float)f1, (float)this.f_102811_.f_104203_, (float)0.0f);
                    this.f_102812_.f_104204_ = this.m_102835_(f2, this.f_102812_.f_104204_, (float)Math.PI);
                    this.f_102811_.f_104204_ = Mth.m_14179_((float)f1, (float)this.f_102811_.f_104204_, (float)((float)Math.PI));
                    this.f_102812_.f_104205_ = this.m_102835_(f2, this.f_102812_.f_104205_, (float)Math.PI + 1.8707964f * this.m_102833_(f5) / this.m_102833_(14.0f));
                    this.f_102811_.f_104205_ = Mth.m_14179_((float)f1, (float)this.f_102811_.f_104205_, (float)((float)Math.PI - 1.8707964f * this.m_102833_(f5) / this.m_102833_(14.0f)));
                } else if (f5 >= 14.0f && f5 < 22.0f) {
                    float f6 = (f5 - 14.0f) / 8.0f;
                    this.f_102812_.f_104203_ = this.m_102835_(f2, this.f_102812_.f_104203_, 1.5707964f * f6);
                    this.f_102811_.f_104203_ = Mth.m_14179_((float)f1, (float)this.f_102811_.f_104203_, (float)(1.5707964f * f6));
                    this.f_102812_.f_104204_ = this.m_102835_(f2, this.f_102812_.f_104204_, (float)Math.PI);
                    this.f_102811_.f_104204_ = Mth.m_14179_((float)f1, (float)this.f_102811_.f_104204_, (float)((float)Math.PI));
                    this.f_102812_.f_104205_ = this.m_102835_(f2, this.f_102812_.f_104205_, 5.012389f - 1.8707964f * f6);
                    this.f_102811_.f_104205_ = Mth.m_14179_((float)f1, (float)this.f_102811_.f_104205_, (float)(1.2707963f + 1.8707964f * f6));
                } else if (f5 >= 22.0f && f5 < 26.0f) {
                    float f32 = (f5 - 22.0f) / 4.0f;
                    this.f_102812_.f_104203_ = this.m_102835_(f2, this.f_102812_.f_104203_, 1.5707964f - 1.5707964f * f32);
                    this.f_102811_.f_104203_ = Mth.m_14179_((float)f1, (float)this.f_102811_.f_104203_, (float)(1.5707964f - 1.5707964f * f32));
                    this.f_102812_.f_104204_ = this.m_102835_(f2, this.f_102812_.f_104204_, (float)Math.PI);
                    this.f_102811_.f_104204_ = Mth.m_14179_((float)f1, (float)this.f_102811_.f_104204_, (float)((float)Math.PI));
                    this.f_102812_.f_104205_ = this.m_102835_(f2, this.f_102812_.f_104205_, (float)Math.PI);
                    this.f_102811_.f_104205_ = Mth.m_14179_((float)f1, (float)this.f_102811_.f_104205_, (float)((float)Math.PI));
                }
            }
            float f7 = 0.3f;
            float f4 = 0.33333334f;
            this.f_102814_.f_104203_ = Mth.m_14179_((float)this.f_102818_, (float)this.f_102814_.f_104203_, (float)(0.3f * Mth.m_14089_((float)(p_102867_ * 0.33333334f + (float)Math.PI))));
            this.f_102813_.f_104203_ = Mth.m_14179_((float)this.f_102818_, (float)this.f_102813_.f_104203_, (float)(0.3f * Mth.m_14089_((float)(p_102867_ * 0.33333334f))));
        }
        this.f_102809_.m_104315_(this.f_102808_);
    }

    private void m_102875_(T p_102876_) {
        switch (this.f_102816_) {
            case EMPTY: {
                this.f_102811_.f_104204_ = 0.0f;
                break;
            }
            case BLOCK: {
                this.f_102811_.f_104203_ = this.f_102811_.f_104203_ * 0.5f - 0.9424779f;
                this.f_102811_.f_104204_ = -0.5235988f;
                break;
            }
            case ITEM: {
                this.f_102811_.f_104203_ = this.f_102811_.f_104203_ * 0.5f - 0.31415927f;
                this.f_102811_.f_104204_ = 0.0f;
                break;
            }
            case THROW_SPEAR: {
                this.f_102811_.f_104203_ = this.f_102811_.f_104203_ * 0.5f - (float)Math.PI;
                this.f_102811_.f_104204_ = 0.0f;
                break;
            }
            case BOW_AND_ARROW: {
                this.f_102811_.f_104204_ = -0.1f + this.f_102808_.f_104204_;
                this.f_102812_.f_104204_ = 0.1f + this.f_102808_.f_104204_ + 0.4f;
                this.f_102811_.f_104203_ = -1.5707964f + this.f_102808_.f_104203_;
                this.f_102812_.f_104203_ = -1.5707964f + this.f_102808_.f_104203_;
                break;
            }
            case CROSSBOW_CHARGE: {
                AnimationUtils.m_102086_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, p_102876_, (boolean)true);
                break;
            }
            case CROSSBOW_HOLD: {
                AnimationUtils.m_102097_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, (ModelPart)this.f_102808_, (boolean)true);
                break;
            }
            case BRUSH: {
                this.f_102811_.f_104203_ = this.f_102811_.f_104203_ * 0.5f - 0.62831855f;
                this.f_102811_.f_104204_ = 0.0f;
                break;
            }
            case SPYGLASS: {
                this.f_102811_.f_104203_ = Mth.m_14036_((float)(this.f_102808_.f_104203_ - 1.9198622f - (((Entity)((Object)p_102876_)).m_6047_() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
                this.f_102811_.f_104204_ = this.f_102808_.f_104204_ - 0.2617994f;
                break;
            }
            case TOOT_HORN: {
                this.f_102811_.f_104203_ = Mth.m_14036_((float)this.f_102808_.f_104203_, (float)-1.2f, (float)1.2f) - 1.4835298f;
                this.f_102811_.f_104204_ = this.f_102808_.f_104204_ - 0.5235988f;
            }
            default: {
                this.f_102816_.applyTransform(this, p_102876_, HumanoidArm.RIGHT);
            }
        }
    }

    private void m_102878_(T p_102879_) {
        switch (this.f_102815_) {
            case EMPTY: {
                this.f_102812_.f_104204_ = 0.0f;
                break;
            }
            case BLOCK: {
                this.f_102812_.f_104203_ = this.f_102812_.f_104203_ * 0.5f - 0.9424779f;
                this.f_102812_.f_104204_ = 0.5235988f;
                break;
            }
            case ITEM: {
                this.f_102812_.f_104203_ = this.f_102812_.f_104203_ * 0.5f - 0.31415927f;
                this.f_102812_.f_104204_ = 0.0f;
                break;
            }
            case THROW_SPEAR: {
                this.f_102812_.f_104203_ = this.f_102812_.f_104203_ * 0.5f - (float)Math.PI;
                this.f_102812_.f_104204_ = 0.0f;
                break;
            }
            case BOW_AND_ARROW: {
                this.f_102811_.f_104204_ = -0.1f + this.f_102808_.f_104204_ - 0.4f;
                this.f_102812_.f_104204_ = 0.1f + this.f_102808_.f_104204_;
                this.f_102811_.f_104203_ = -1.5707964f + this.f_102808_.f_104203_;
                this.f_102812_.f_104203_ = -1.5707964f + this.f_102808_.f_104203_;
                break;
            }
            case CROSSBOW_CHARGE: {
                AnimationUtils.m_102086_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, p_102879_, (boolean)false);
                break;
            }
            case CROSSBOW_HOLD: {
                AnimationUtils.m_102097_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, (ModelPart)this.f_102808_, (boolean)false);
                break;
            }
            case BRUSH: {
                this.f_102812_.f_104203_ = this.f_102812_.f_104203_ * 0.5f - 0.62831855f;
                this.f_102812_.f_104204_ = 0.0f;
                break;
            }
            case SPYGLASS: {
                this.f_102812_.f_104203_ = Mth.m_14036_((float)(this.f_102808_.f_104203_ - 1.9198622f - (((Entity)((Object)p_102879_)).m_6047_() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
                this.f_102812_.f_104204_ = this.f_102808_.f_104204_ + 0.2617994f;
                break;
            }
            case TOOT_HORN: {
                this.f_102812_.f_104203_ = Mth.m_14036_((float)this.f_102808_.f_104203_, (float)-1.2f, (float)1.2f) - 1.4835298f;
                this.f_102812_.f_104204_ = this.f_102808_.f_104204_ + 0.5235988f;
            }
            default: {
                this.f_102815_.applyTransform(this, p_102879_, HumanoidArm.LEFT);
            }
        }
    }

    protected void m_7884_(T p_102858_, float p_102859_) {
        if (!(this.f_102608_ <= 0.0f)) {
            HumanoidArm humanoidarm = this.m_102856_(p_102858_);
            ModelPart modelpart = this.m_102851_(humanoidarm);
            float f = this.f_102608_;
            this.f_102810_.f_104204_ = Mth.m_14031_((float)(Mth.m_14116_((float)f) * ((float)Math.PI * 2))) * 0.2f;
            if (humanoidarm == HumanoidArm.LEFT) {
                this.f_102810_.f_104204_ *= -1.0f;
            }
            this.f_102811_.f_104202_ = Mth.m_14031_((float)this.f_102810_.f_104204_) * 5.0f;
            this.f_102811_.f_104200_ = -Mth.m_14089_((float)this.f_102810_.f_104204_) * 5.0f;
            this.f_102812_.f_104202_ = -Mth.m_14031_((float)this.f_102810_.f_104204_) * 5.0f;
            this.f_102812_.f_104200_ = Mth.m_14089_((float)this.f_102810_.f_104204_) * 5.0f;
            this.f_102811_.f_104204_ += this.f_102810_.f_104204_;
            this.f_102812_.f_104204_ += this.f_102810_.f_104204_;
            this.f_102812_.f_104203_ += this.f_102810_.f_104204_;
            f = 1.0f - this.f_102608_;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = Mth.m_14031_((float)(f * (float)Math.PI));
            float f2 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.f_102808_.f_104203_ - 0.7f) * 0.75f;
            modelpart.f_104203_ -= f1 * 1.2f + f2;
            modelpart.f_104204_ += this.f_102810_.f_104204_ * 2.0f;
            modelpart.f_104205_ += Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -0.4f;
        }
    }

    protected float m_102835_(float p_102836_, float p_102837_, float p_102838_) {
        float f = (p_102838_ - p_102837_) % ((float)Math.PI * 2);
        if (f < (float)(-Math.PI)) {
            f += (float)Math.PI * 2;
        }
        if (f >= (float)Math.PI) {
            f -= (float)Math.PI * 2;
        }
        return p_102837_ + p_102836_ * f;
    }

    private float m_102833_(float p_102834_) {
        return -65.0f * p_102834_ + p_102834_ * p_102834_;
    }

    public void m_102872_(HumanoidModel<T> p_102873_) {
        super.m_102624_(p_102873_);
        p_102873_.f_102815_ = this.f_102815_;
        p_102873_.f_102816_ = this.f_102816_;
        p_102873_.f_102817_ = this.f_102817_;
        p_102873_.f_102808_.m_104315_(this.f_102808_);
        p_102873_.f_102809_.m_104315_(this.f_102809_);
        p_102873_.f_102810_.m_104315_(this.f_102810_);
        p_102873_.f_102811_.m_104315_(this.f_102811_);
        p_102873_.f_102812_.m_104315_(this.f_102812_);
        p_102873_.f_102813_.m_104315_(this.f_102813_);
        p_102873_.f_102814_.m_104315_(this.f_102814_);
    }

    public void m_8009_(boolean p_102880_) {
        this.f_102808_.f_104207_ = p_102880_;
        this.f_102809_.f_104207_ = p_102880_;
        this.f_102810_.f_104207_ = p_102880_;
        this.f_102811_.f_104207_ = p_102880_;
        this.f_102812_.f_104207_ = p_102880_;
        this.f_102813_.f_104207_ = p_102880_;
        this.f_102814_.f_104207_ = p_102880_;
    }

    public void m_6002_(HumanoidArm p_102854_, PoseStack p_102855_) {
        this.m_102851_(p_102854_).m_104299_(p_102855_);
    }

    protected ModelPart m_102851_(HumanoidArm p_102852_) {
        return p_102852_ == HumanoidArm.LEFT ? this.f_102812_ : this.f_102811_;
    }

    public ModelPart m_5585_() {
        return this.f_102808_;
    }

    private HumanoidArm m_102856_(T p_102857_) {
        HumanoidArm humanoidarm = ((LivingEntity)((Object)p_102857_)).m_5737_();
        return ((LivingEntity)((Object)p_102857_)).f_20912_ == InteractionHand.MAIN_HAND ? humanoidarm : humanoidarm.m_20828_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class ArmPose
    extends Enum<ArmPose>
    implements IExtensibleEnum {
        public static final /* enum */ ArmPose EMPTY = new ArmPose(false);
        public static final /* enum */ ArmPose ITEM = new ArmPose(false);
        public static final /* enum */ ArmPose BLOCK = new ArmPose(false);
        public static final /* enum */ ArmPose BOW_AND_ARROW = new ArmPose(true);
        public static final /* enum */ ArmPose THROW_SPEAR = new ArmPose(false);
        public static final /* enum */ ArmPose CROSSBOW_CHARGE = new ArmPose(true);
        public static final /* enum */ ArmPose CROSSBOW_HOLD = new ArmPose(true);
        public static final /* enum */ ArmPose SPYGLASS = new ArmPose(false);
        public static final /* enum */ ArmPose TOOT_HORN = new ArmPose(false);
        public static final /* enum */ ArmPose BRUSH = new ArmPose(false);
        private final boolean f_102890_;
        @Nullable
        private final IArmPoseTransformer forgeArmPose;
        private static final /* synthetic */ ArmPose[] $VALUES;

        public static ArmPose[] values() {
            return (ArmPose[])$VALUES.clone();
        }

        public static ArmPose valueOf(String p_102899_) {
            return Enum.valueOf(ArmPose.class, p_102899_);
        }

        private ArmPose(boolean p_102896_) {
            this.f_102890_ = p_102896_;
            this.forgeArmPose = null;
        }

        public boolean m_102897_() {
            return this.f_102890_;
        }

        private ArmPose(boolean twoHanded, IArmPoseTransformer forgeArmPose) {
            this.f_102890_ = twoHanded;
            Preconditions.checkNotNull((Object)forgeArmPose, (Object)"Cannot create new ArmPose with null transformer!");
            this.forgeArmPose = forgeArmPose;
        }

        public static ArmPose create(String name, boolean twoHanded, @Nonnull IArmPoseTransformer forgeArmPose) {
            throw new IllegalStateException("Enum not extended");
        }

        public <T extends LivingEntity> void applyTransform(HumanoidModel<T> model, T entity, HumanoidArm arm) {
            if (this.forgeArmPose != null) {
                this.forgeArmPose.applyTransform(model, entity, arm);
            }
        }

        private static /* synthetic */ ArmPose[] m_170685_() {
            return new ArmPose[]{EMPTY, ITEM, BLOCK, BOW_AND_ARROW, THROW_SPEAR, CROSSBOW_CHARGE, CROSSBOW_HOLD, SPYGLASS, TOOT_HORN, BRUSH};
        }

        static {
            $VALUES = ArmPose.m_170685_();
        }
    }
}

