/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.telemetry;

import com.mojang.authlib.minecraft.TelemetryPropertyContainer;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.telemetry.TelemetryPropertyMap;
import net.minecraft.client.telemetry.events.GameLoadTimesEvent;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;

public record TelemetryProperty<T>(String f_260687_, String f_260588_, Codec<T> f_260706_, Exporter<T> f_260625_) {
    private static final DateTimeFormatter f_260684_ = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.from(ZoneOffset.UTC));
    public static final TelemetryProperty<String> f_260659_ = TelemetryProperty.m_261074_("user_id", "userId");
    public static final TelemetryProperty<String> f_260475_ = TelemetryProperty.m_261074_("client_id", "clientId");
    public static final TelemetryProperty<UUID> f_260530_ = TelemetryProperty.m_260851_("minecraft_session_id", "deviceSessionId");
    public static final TelemetryProperty<String> f_260597_ = TelemetryProperty.m_261074_("game_version", "buildDisplayName");
    public static final TelemetryProperty<String> f_260441_ = TelemetryProperty.m_261074_("operating_system", "buildPlatform");
    public static final TelemetryProperty<String> f_260586_ = TelemetryProperty.m_261074_("platform", "platform");
    public static final TelemetryProperty<Boolean> f_260562_ = TelemetryProperty.m_261193_("client_modded", "clientModded");
    public static final TelemetryProperty<String> f_285658_ = TelemetryProperty.m_261074_("launcher_name", "launcherName");
    public static final TelemetryProperty<UUID> f_260511_ = TelemetryProperty.m_260851_("world_session_id", "worldSessionId");
    public static final TelemetryProperty<Boolean> f_260499_ = TelemetryProperty.m_261193_("server_modded", "serverModded");
    public static final TelemetryProperty<ServerType> f_260635_ = TelemetryProperty.m_261147_("server_type", "serverType", ServerType.f_260675_, (p_261518_, p_262138_, p_262085_) -> p_261518_.addProperty(p_262138_, p_262085_.m_7912_()));
    public static final TelemetryProperty<Boolean> f_260453_ = TelemetryProperty.m_261193_("opt_in", "isOptional");
    public static final TelemetryProperty<Instant> f_260726_ = TelemetryProperty.m_261147_("event_timestamp_utc", "eventTimestampUtc", ExtraCodecs.f_216159_, (p_261517_, p_261626_, p_261868_) -> p_261517_.addProperty(p_261626_, f_260684_.format((TemporalAccessor)p_261868_)));
    public static final TelemetryProperty<GameMode> f_260704_ = TelemetryProperty.m_261147_("game_mode", "playerGameMode", GameMode.f_260532_, (p_261849_, p_262092_, p_261574_) -> p_261849_.addProperty(p_262092_, p_261574_.m_261006_()));
    public static final TelemetryProperty<String> f_285634_ = TelemetryProperty.m_261074_("realms_map_content", "realmsMapContent");
    public static final TelemetryProperty<Integer> f_260452_ = TelemetryProperty.m_261234_("seconds_since_load", "secondsSinceLoad");
    public static final TelemetryProperty<Integer> f_260638_ = TelemetryProperty.m_261234_("ticks_since_load", "ticksSinceLoad");
    public static final TelemetryProperty<LongList> f_260557_ = TelemetryProperty.m_261255_("frame_rate_samples", "serializedFpsSamples");
    public static final TelemetryProperty<LongList> f_260713_ = TelemetryProperty.m_261255_("render_time_samples", "serializedRenderTimeSamples");
    public static final TelemetryProperty<LongList> f_260645_ = TelemetryProperty.m_261255_("used_memory_samples", "serializedUsedMemoryKbSamples");
    public static final TelemetryProperty<Integer> f_260649_ = TelemetryProperty.m_261234_("number_of_samples", "numSamples");
    public static final TelemetryProperty<Integer> f_260683_ = TelemetryProperty.m_261234_("render_distance", "renderDistance");
    public static final TelemetryProperty<Integer> f_260700_ = TelemetryProperty.m_261234_("dedicated_memory_kb", "dedicatedMemoryKb");
    public static final TelemetryProperty<Integer> f_260571_ = TelemetryProperty.m_261234_("world_load_time_ms", "worldLoadTimeMs");
    public static final TelemetryProperty<Boolean> f_260437_ = TelemetryProperty.m_261193_("new_world", "newWorld");
    public static final TelemetryProperty<GameLoadTimesEvent.Measurement> f_285605_ = TelemetryProperty.m_285885_("load_time_total_time_ms", "loadTimeTotalTimeMs");
    public static final TelemetryProperty<GameLoadTimesEvent.Measurement> f_285649_ = TelemetryProperty.m_285885_("load_time_pre_window_ms", "loadTimePreWindowMs");
    public static final TelemetryProperty<GameLoadTimesEvent.Measurement> f_285586_ = TelemetryProperty.m_285885_("load_time_bootstrap_ms", "loadTimeBootstrapMs");
    public static final TelemetryProperty<GameLoadTimesEvent.Measurement> f_285629_ = TelemetryProperty.m_285885_("load_time_loading_overlay_ms", "loadTimeLoadingOverlayMs");
    public static final TelemetryProperty<String> f_285565_ = TelemetryProperty.m_261074_("advancement_id", "advancementId");
    public static final TelemetryProperty<Long> f_285625_ = TelemetryProperty.m_286063_("advancement_game_time", "advancementGameTime");

    public static <T> TelemetryProperty<T> m_261147_(String p_262052_, String p_261851_, Codec<T> p_261617_, Exporter<T> p_261478_) {
        return new TelemetryProperty<T>(p_262052_, p_261851_, p_261617_, p_261478_);
    }

    public static TelemetryProperty<Boolean> m_261193_(String p_261605_, String p_262064_) {
        return TelemetryProperty.m_261147_(p_261605_, p_262064_, Codec.BOOL, TelemetryPropertyContainer::addProperty);
    }

    public static TelemetryProperty<String> m_261074_(String p_261570_, String p_261611_) {
        return TelemetryProperty.m_261147_(p_261570_, p_261611_, Codec.STRING, TelemetryPropertyContainer::addProperty);
    }

    public static TelemetryProperty<Integer> m_261234_(String p_262077_, String p_261580_) {
        return TelemetryProperty.m_261147_(p_262077_, p_261580_, Codec.INT, TelemetryPropertyContainer::addProperty);
    }

    public static TelemetryProperty<Long> m_286063_(String p_286489_, String p_286616_) {
        return TelemetryProperty.m_261147_(p_286489_, p_286616_, Codec.LONG, TelemetryPropertyContainer::addProperty);
    }

    public static TelemetryProperty<UUID> m_260851_(String p_261558_, String p_261707_) {
        return TelemetryProperty.m_261147_(p_261558_, p_261707_, UUIDUtil.f_260719_, (p_261704_, p_261590_, p_261975_) -> p_261704_.addProperty(p_261590_, p_261975_.toString()));
    }

    public static TelemetryProperty<GameLoadTimesEvent.Measurement> m_285885_(String p_286636_, String p_286769_) {
        return TelemetryProperty.m_261147_(p_286636_, p_286769_, GameLoadTimesEvent.Measurement.f_285618_, (p_286179_, p_286180_, p_286181_) -> p_286179_.addProperty(p_286180_, p_286181_.f_285578_()));
    }

    public static TelemetryProperty<LongList> m_261255_(String p_262055_, String p_261726_) {
        return TelemetryProperty.m_261147_(p_262055_, p_261726_, Codec.LONG.listOf().xmap(LongArrayList::new, Function.identity()), (p_261674_, p_262049_, p_262118_) -> p_261674_.addProperty(p_262049_, p_262118_.longStream().mapToObj(String::valueOf).collect(Collectors.joining(";"))));
    }

    public void m_261124_(TelemetryPropertyMap p_262111_, TelemetryPropertyContainer p_262082_) {
        Object $$2 = p_262111_.m_260858_(this);
        if ($$2 != null) {
            this.f_260625_.m_261109_(p_262082_, this.f_260588_, $$2);
        } else {
            p_262082_.addNullProperty(this.f_260588_);
        }
    }

    public MutableComponent m_261229_() {
        return Component.m_237115_("telemetry.property." + this.f_260687_ + ".title");
    }

    @Override
    public String toString() {
        return "TelemetryProperty[" + this.f_260687_ + "]";
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TelemetryProperty.class, "id;exportKey;codec;exporter", "f_260687_", "f_260588_", "f_260706_", "f_260625_"}, this);
    }

    @Override
    public final boolean equals(Object p_261543_) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TelemetryProperty.class, "id;exportKey;codec;exporter", "f_260687_", "f_260588_", "f_260706_", "f_260625_"}, this, p_261543_);
    }

    public static interface Exporter<T> {
        public void m_261109_(TelemetryPropertyContainer var1, String var2, T var3);
    }

    public static final class GameMode
    extends Enum<GameMode>
    implements StringRepresentable {
        public static final /* enum */ GameMode SURVIVAL = new GameMode("survival", 0);
        public static final /* enum */ GameMode CREATIVE = new GameMode("creative", 1);
        public static final /* enum */ GameMode ADVENTURE = new GameMode("adventure", 2);
        public static final /* enum */ GameMode SPECTATOR = new GameMode("spectator", 6);
        public static final /* enum */ GameMode HARDCORE = new GameMode("hardcore", 99);
        public static final Codec<GameMode> f_260532_;
        private final String f_260535_;
        private final int f_260720_;
        private static final /* synthetic */ GameMode[] $VALUES;

        public static GameMode[] values() {
            return (GameMode[])$VALUES.clone();
        }

        public static GameMode valueOf(String p_262058_) {
            return Enum.valueOf(GameMode.class, p_262058_);
        }

        private GameMode(String p_261661_, int p_261545_) {
            this.f_260535_ = p_261661_;
            this.f_260720_ = p_261545_;
        }

        public int m_261006_() {
            return this.f_260720_;
        }

        @Override
        public String m_7912_() {
            return this.f_260535_;
        }

        private static /* synthetic */ GameMode[] m_260807_() {
            return new GameMode[]{SURVIVAL, CREATIVE, ADVENTURE, SPECTATOR, HARDCORE};
        }

        static {
            $VALUES = GameMode.m_260807_();
            f_260532_ = StringRepresentable.m_216439_(GameMode::values);
        }
    }

    public static final class ServerType
    extends Enum<ServerType>
    implements StringRepresentable {
        public static final /* enum */ ServerType REALM = new ServerType("realm");
        public static final /* enum */ ServerType LOCAL = new ServerType("local");
        public static final /* enum */ ServerType OTHER = new ServerType("server");
        public static final Codec<ServerType> f_260675_;
        private final String f_260545_;
        private static final /* synthetic */ ServerType[] $VALUES;

        public static ServerType[] values() {
            return (ServerType[])$VALUES.clone();
        }

        public static ServerType valueOf(String p_262157_) {
            return Enum.valueOf(ServerType.class, p_262157_);
        }

        private ServerType(String p_261499_) {
            this.f_260545_ = p_261499_;
        }

        @Override
        public String m_7912_() {
            return this.f_260545_;
        }

        private static /* synthetic */ ServerType[] m_261195_() {
            return new ServerType[]{REALM, LOCAL, OTHER};
        }

        static {
            $VALUES = ServerType.m_261195_();
            f_260675_ = StringRepresentable.m_216439_(ServerType::values);
        }
    }
}

