/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.forgewrapper.installer;

import cpw.mods.modlauncher.Launcher;
import io.github.zekerzhayard.forgewrapper.installer.Bootstrap;
import io.github.zekerzhayard.forgewrapper.installer.detector.DetectorLoader;
import io.github.zekerzhayard.forgewrapper.installer.detector.IFileDetector;
import io.github.zekerzhayard.forgewrapper.installer.util.ModuleUtil;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Main {
    public static void main(String[] args) throws Throwable {
        List argsList = Stream.of(args).collect(Collectors.toList());
        boolean isNeoForge = argsList.contains("--fml.neoForgeVersion");
        String mcVersion = (String)argsList.get(argsList.indexOf("--fml.mcVersion") + 1);
        String forgeGroup = argsList.contains("--fml.forgeGroup") ? (String)argsList.get(argsList.indexOf("--fml.forgeGroup") + 1) : "net.neoforged";
        String forgeArtifact = isNeoForge ? "neoforge" : "forge";
        String forgeVersionKey = isNeoForge ? "--fml.neoForgeVersion" : "--fml.forgeVersion";
        String forgeVersion = (String)argsList.get(argsList.indexOf(forgeVersionKey) + 1);
        String forgeFullVersion = isNeoForge ? forgeVersion : mcVersion + "-" + forgeVersion;
        String launchTarget = (String)argsList.get(argsList.indexOf("--launchTarget") + 1);
        IFileDetector detector = DetectorLoader.loadDetector();
        Path installerJar = detector.getInstallerJar(forgeGroup, forgeArtifact, forgeFullVersion);
        if (!Main.isFile(installerJar)) {
            throw new RuntimeException("Unable to detect the forge installer!");
        }
        Path minecraftJar = detector.getMinecraftJar(mcVersion);
        if (!Main.isFile(minecraftJar)) {
            throw new RuntimeException("Unable to detect the Minecraft jar!");
        }
        try (URLClassLoader ucl = URLClassLoader.newInstance(new URL[]{Main.class.getProtectionDomain().getCodeSource().getLocation(), Launcher.class.getProtectionDomain().getCodeSource().getLocation(), installerJar.toUri().toURL()}, ModuleUtil.getPlatformClassLoader());){
            Class<?> installer = ucl.loadClass("io.github.zekerzhayard.forgewrapper.installer.Installer");
            Map data = (Map)installer.getMethod("getData", File.class).invoke(null, detector.getLibraryDir().toFile());
            try {
                Bootstrap.bootstrap((String[])data.get("jvmArgs"), detector.getMinecraftJar(mcVersion).getFileName().toString(), detector.getLibraryDir().toAbsolutePath().toString());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (argsList.contains("--setup")) {
                installer.getMethod("install", File.class, File.class, File.class, String.class).invoke(null, detector.getLibraryDir().toFile(), minecraftJar.toFile(), installerJar.toFile(), launchTarget);
                return;
            }
            ModuleUtil.setupClassPath(detector.getLibraryDir(), (List)data.get("extraLibraries"));
            Class<?> mainClass = ModuleUtil.setupBootstrapLauncher(Class.forName((String)data.get("mainClass")));
            mainClass.getMethod("main", String[].class).invoke(null, new Object[]{args});
        }
    }

    private static boolean isFile(Path path) {
        return path != null && Files.isRegularFile(path, new LinkOption[0]);
    }
}

