/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.windows.wmi.MSAcpiThermalZoneTemperature;
import oshi.driver.windows.wmi.OhmHardware;
import oshi.driver.windows.wmi.OhmSensor;
import oshi.driver.windows.wmi.Win32Fan;
import oshi.driver.windows.wmi.Win32Processor;
import oshi.hardware.common.AbstractSensors;
import oshi.util.platform.windows.WmiQueryHandler;
import oshi.util.platform.windows.WmiUtil;

@ThreadSafe
final class WindowsSensors
extends AbstractSensors {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsSensors.class);
    private static final String COM_EXCEPTION_MSG = "COM exception: {}";
    private static final String REFLECT_EXCEPTION_MSG = "Reflect exception: {}";
    private static final String JLIBREHARDWAREMONITOR_PACKAGE = "io.github.pandalxb.jlibrehardwaremonitor";

    WindowsSensors() {
    }

    @Override
    public double queryCpuTemperature() {
        double d = WindowsSensors.getTempFromOHM();
        if (d > 0.0) {
            return d;
        }
        d = WindowsSensors.getTempFromLHM();
        if (d > 0.0) {
            return d;
        }
        d = WindowsSensors.getTempFromWMI();
        return d;
    }

    private static double getTempFromOHM() {
        WbemcliUtil.WmiResult<OhmSensor.ValueProperty> wmiResult2 = WindowsSensors.getOhmSensors("Hardware", "CPU", "Temperature", (wmiQueryHandler, wmiResult) -> {
            String string = WmiUtil.getString(wmiResult, OhmHardware.IdentifierProperty.IDENTIFIER, 0);
            if (!string.isEmpty()) {
                return OhmSensor.querySensorValue(wmiQueryHandler, string, "Temperature");
            }
            return null;
        });
        if (wmiResult2 != null && wmiResult2.getResultCount() > 0) {
            double d = 0.0;
            for (int i = 0; i < wmiResult2.getResultCount(); ++i) {
                d += (double)WmiUtil.getFloat(wmiResult2, OhmSensor.ValueProperty.VALUE, i);
            }
            return d / (double)wmiResult2.getResultCount();
        }
        return 0.0;
    }

    private static double getTempFromLHM() {
        return WindowsSensors.getAverageValueFromLHM("CPU", "Temperature", (string, d) -> !string.contains("Max") && !string.contains("Average") && d > 0.0);
    }

    private static double getTempFromWMI() {
        double d = 0.0;
        long l = 0L;
        WbemcliUtil.WmiResult<MSAcpiThermalZoneTemperature.TemperatureProperty> wmiResult = MSAcpiThermalZoneTemperature.queryCurrentTemperature();
        if (wmiResult.getResultCount() > 0) {
            LOG.debug("Found Temperature data in WMI");
            l = WmiUtil.getUint32asLong(wmiResult, MSAcpiThermalZoneTemperature.TemperatureProperty.CURRENTTEMPERATURE, 0);
        }
        if (l > 2732L) {
            d = (double)l / 10.0 - 273.15;
        } else if (l > 274L) {
            d = (double)l - 273.0;
        }
        return Math.max(d, 0.0);
    }

    @Override
    public int[] queryFanSpeeds() {
        int[] nArray = WindowsSensors.getFansFromOHM();
        if (nArray.length > 0) {
            return nArray;
        }
        nArray = WindowsSensors.getFansFromLHM();
        if (nArray.length > 0) {
            return nArray;
        }
        nArray = WindowsSensors.getFansFromWMI();
        if (nArray.length > 0) {
            return nArray;
        }
        return new int[0];
    }

    private static int[] getFansFromOHM() {
        WbemcliUtil.WmiResult<OhmSensor.ValueProperty> wmiResult2 = WindowsSensors.getOhmSensors("Hardware", "CPU", "Fan", (wmiQueryHandler, wmiResult) -> {
            String string = WmiUtil.getString(wmiResult, OhmHardware.IdentifierProperty.IDENTIFIER, 0);
            if (!string.isEmpty()) {
                return OhmSensor.querySensorValue(wmiQueryHandler, string, "Fan");
            }
            return null;
        });
        if (wmiResult2 != null && wmiResult2.getResultCount() > 0) {
            int[] nArray = new int[wmiResult2.getResultCount()];
            for (int i = 0; i < wmiResult2.getResultCount(); ++i) {
                nArray[i] = (int)WmiUtil.getFloat(wmiResult2, OhmSensor.ValueProperty.VALUE, i);
            }
            return nArray;
        }
        return new int[0];
    }

    private static int[] getFansFromLHM() {
        List<?> list = WindowsSensors.getLhmSensors("SuperIO", "Fan");
        if (list == null || list.isEmpty()) {
            return new int[0];
        }
        try {
            Class<?> clazz = Class.forName("io.github.pandalxb.jlibrehardwaremonitor.model.Sensor");
            Method method = clazz.getMethod("getValue", new Class[0]);
            return list.stream().filter(object -> {
                try {
                    double d = (Double)method.invoke(object, new Object[0]);
                    return d > 0.0;
                }
                catch (Exception exception) {
                    LOG.warn(REFLECT_EXCEPTION_MSG, (Object)exception.getMessage());
                    return false;
                }
            }).mapToInt(object -> {
                try {
                    return (int)((Double)method.invoke(object, new Object[0])).doubleValue();
                }
                catch (Exception exception) {
                    LOG.warn(REFLECT_EXCEPTION_MSG, (Object)exception.getMessage());
                    return 0;
                }
            }).toArray();
        }
        catch (Exception exception) {
            LOG.warn(REFLECT_EXCEPTION_MSG, (Object)exception.getMessage());
            return new int[0];
        }
    }

    private static int[] getFansFromWMI() {
        WbemcliUtil.WmiResult<Win32Fan.SpeedProperty> wmiResult = Win32Fan.querySpeed();
        if (wmiResult.getResultCount() > 1) {
            LOG.debug("Found Fan data in WMI");
            int[] nArray = new int[wmiResult.getResultCount()];
            for (int i = 0; i < wmiResult.getResultCount(); ++i) {
                nArray[i] = (int)WmiUtil.getUint64(wmiResult, Win32Fan.SpeedProperty.DESIREDSPEED, i);
            }
            return nArray;
        }
        return new int[0];
    }

    @Override
    public double queryCpuVoltage() {
        double d = WindowsSensors.getVoltsFromOHM();
        if (d > 0.0) {
            return d;
        }
        d = WindowsSensors.getVoltsFromLHM();
        if (d > 0.0) {
            return d;
        }
        d = WindowsSensors.getVoltsFromWMI();
        return d;
    }

    private static double getVoltsFromOHM() {
        WbemcliUtil.WmiResult<OhmSensor.ValueProperty> wmiResult2 = WindowsSensors.getOhmSensors("Sensor", "Voltage", "Voltage", (wmiQueryHandler, wmiResult) -> {
            String string = null;
            for (int i = 0; i < wmiResult.getResultCount(); ++i) {
                String string2 = WmiUtil.getString(wmiResult, OhmHardware.IdentifierProperty.IDENTIFIER, i);
                if (!string2.toLowerCase(Locale.ROOT).contains("cpu")) continue;
                string = string2;
                break;
            }
            if (string == null) {
                string = WmiUtil.getString(wmiResult, OhmHardware.IdentifierProperty.IDENTIFIER, 0);
            }
            return OhmSensor.querySensorValue(wmiQueryHandler, string, "Voltage");
        });
        if (wmiResult2 != null && wmiResult2.getResultCount() > 0) {
            return WmiUtil.getFloat(wmiResult2, OhmSensor.ValueProperty.VALUE, 0);
        }
        return 0.0;
    }

    private static double getVoltsFromLHM() {
        return WindowsSensors.getAverageValueFromLHM("SuperIO", "Voltage", (string, d) -> string.toLowerCase(Locale.ROOT).contains("vcore") && d > 0.0);
    }

    private static double getVoltsFromWMI() {
        WbemcliUtil.WmiResult<Win32Processor.VoltProperty> wmiResult = Win32Processor.queryVoltage();
        if (wmiResult.getResultCount() > 1) {
            LOG.debug("Found Voltage data in WMI");
            int n = WmiUtil.getUint16(wmiResult, Win32Processor.VoltProperty.CURRENTVOLTAGE, 0);
            if (n > 0) {
                if ((n & 0x80) == 0) {
                    n = WmiUtil.getUint32(wmiResult, Win32Processor.VoltProperty.VOLTAGECAPS, 0);
                    if ((n & 1) > 0) {
                        return 5.0;
                    }
                    if ((n & 2) > 0) {
                        return 3.3;
                    }
                    if ((n & 4) > 0) {
                        return 2.9;
                    }
                } else {
                    return (double)(n & 0x7F) / 10.0;
                }
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WbemcliUtil.WmiResult<OhmSensor.ValueProperty> getOhmSensors(String string, String string2, String string3, BiFunction<WmiQueryHandler, WbemcliUtil.WmiResult<OhmHardware.IdentifierProperty>, WbemcliUtil.WmiResult<OhmSensor.ValueProperty>> biFunction) {
        WmiQueryHandler wmiQueryHandler = Objects.requireNonNull(WmiQueryHandler.createInstance());
        boolean bl = false;
        WbemcliUtil.WmiResult<OhmSensor.ValueProperty> wmiResult = null;
        try {
            bl = wmiQueryHandler.initCOM();
            WbemcliUtil.WmiResult<OhmHardware.IdentifierProperty> wmiResult2 = OhmHardware.queryHwIdentifier(wmiQueryHandler, string, string2);
            if (wmiResult2.getResultCount() > 0) {
                LOG.debug("Found {} data in Open Hardware Monitor", (Object)string3);
                wmiResult = biFunction.apply(wmiQueryHandler, wmiResult2);
            }
        }
        catch (COMException cOMException) {
            LOG.warn(COM_EXCEPTION_MSG, (Object)cOMException.getMessage());
        }
        finally {
            if (bl) {
                wmiQueryHandler.unInitCOM();
            }
        }
        return wmiResult;
    }

    private static double getAverageValueFromLHM(String string, String string2, BiFunction<String, Double, Boolean> biFunction) {
        List<?> list = WindowsSensors.getLhmSensors(string, string2);
        if (list == null || list.isEmpty()) {
            return 0.0;
        }
        try {
            Class<?> clazz = Class.forName("io.github.pandalxb.jlibrehardwaremonitor.model.Sensor");
            Method method = clazz.getMethod("getName", new Class[0]);
            Method method2 = clazz.getMethod("getValue", new Class[0]);
            double d = 0.0;
            int n = 0;
            for (Object obj : list) {
                double d2;
                String string3 = (String)method.invoke(obj, new Object[0]);
                if (!biFunction.apply(string3, d2 = ((Double)method2.invoke(obj, new Object[0])).doubleValue()).booleanValue()) continue;
                d += d2;
                ++n;
            }
            return n > 0 ? d / (double)n : 0.0;
        }
        catch (Exception exception) {
            LOG.warn(REFLECT_EXCEPTION_MSG, (Object)exception.getMessage());
            return 0.0;
        }
    }

    private static List<?> getLhmSensors(String string, String string2) {
        try {
            Class<?> clazz = Class.forName("io.github.pandalxb.jlibrehardwaremonitor.config.ComputerConfig");
            Class<?> clazz2 = Class.forName("io.github.pandalxb.jlibrehardwaremonitor.manager.LibreHardwareManager");
            Method method = clazz.getMethod("getInstance", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            Method method2 = clazz.getMethod("setCpuEnabled", Boolean.TYPE);
            method2.invoke(object, true);
            method2 = clazz.getMethod("setMotherboardEnabled", Boolean.TYPE);
            method2.invoke(object, true);
            Method method3 = clazz2.getMethod("getInstance", clazz);
            Object object2 = method3.invoke(null, object);
            Method method4 = clazz2.getMethod("querySensors", String.class, String.class);
            return (List)method4.invoke(object2, string, string2);
        }
        catch (Exception exception) {
            LOG.warn(REFLECT_EXCEPTION_MSG, (Object)exception.getMessage());
            return Collections.emptyList();
        }
    }
}

