/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.freebsd;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.PowerSource;
import oshi.hardware.common.AbstractPowerSource;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.freebsd.BsdSysctlUtil;

@ThreadSafe
public final class FreeBsdPowerSource
extends AbstractPowerSource {
    public FreeBsdPowerSource(String string, String string2, double d, double d2, double d3, double d4, double d5, double d6, boolean bl, boolean bl2, boolean bl3, PowerSource.CapacityUnits capacityUnits, int n, int n2, int n3, int n4, String string3, LocalDate localDate, String string4, String string5, double d7) {
        super(string, string2, d, d2, d3, d4, d5, d6, bl, bl2, bl3, capacityUnits, n, n2, n3, n4, string3, localDate, string4, string5, d7);
    }

    public static List<PowerSource> getPowerSources() {
        return Arrays.asList(FreeBsdPowerSource.getPowerSource("BAT0"));
    }

    private static FreeBsdPowerSource getPowerSource(String string) {
        String string2;
        Object object;
        String string3;
        Object object2;
        String string42;
        int n;
        String string5 = string;
        double d = 1.0;
        double d2 = -1.0;
        double d3 = 0.0;
        int n2 = -1;
        double d4 = 0.0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        PowerSource.CapacityUnits capacityUnits = PowerSource.CapacityUnits.RELATIVE;
        int n3 = 0;
        int n4 = 1;
        int n5 = 1;
        int n6 = -1;
        LocalDate localDate = null;
        double d5 = 0.0;
        int n7 = BsdSysctlUtil.sysctl("hw.acpi.battery.state", 0);
        if (n7 == 2) {
            bl2 = true;
        } else {
            n = BsdSysctlUtil.sysctl("hw.acpi.battery.time", -1);
            double d6 = d2 = n < 0 ? -1.0 : 60.0 * (double)n;
            if (n7 == 1) {
                bl3 = true;
            }
        }
        n = BsdSysctlUtil.sysctl("hw.acpi.battery.life", -1);
        if (n > 0) {
            d = (double)n / 100.0;
        }
        List<String> list = ExecutingCommand.runNative("acpiconf -i 0");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string42 : list) {
            object2 = string42.split(":", 2);
            if (((String[])object2).length <= 1 || (string3 = object2[1].trim()).isEmpty()) continue;
            hashMap.put(object2[0], string3);
        }
        String string6 = hashMap.getOrDefault("Model number", "unknown");
        string42 = hashMap.getOrDefault("Serial number", "unknown");
        object2 = hashMap.getOrDefault("Type", "unknown");
        string3 = hashMap.getOrDefault("OEM info", "unknown");
        String string7 = (String)hashMap.get("Design capacity");
        if (string7 != null) {
            n5 = ParseUtil.getFirstIntValue(string7);
            if (string7.toLowerCase(Locale.ROOT).contains("mah")) {
                capacityUnits = PowerSource.CapacityUnits.MAH;
            } else if (string7.toLowerCase(Locale.ROOT).contains("mwh")) {
                capacityUnits = PowerSource.CapacityUnits.MWH;
            }
        }
        n4 = (string7 = (String)hashMap.get("Last full capacity")) != null ? ParseUtil.getFirstIntValue(string7) : n5;
        double d7 = d2;
        String string8 = (String)hashMap.get("Remaining time");
        if (string8 != null && ((String[])(object = string8.split(":"))).length == 2) {
            d7 = 3600.0 * (double)ParseUtil.parseIntOrDefault(object[0], 0) + 60.0 * (double)ParseUtil.parseIntOrDefault(object[1], 0);
        }
        if ((object = (String)hashMap.get("Present rate")) != null) {
            d3 = ParseUtil.getFirstIntValue((String)object);
        }
        if ((string2 = (String)hashMap.get("Present voltage")) != null && (n2 = ParseUtil.getFirstIntValue(string2)) != 0) {
            d4 = d3 / (double)n2;
        }
        return new FreeBsdPowerSource(string5, string6, d, d2, d7, d3, n2, d4, bl, bl2, bl3, capacityUnits, n3, n4, n5, n6, (String)object2, localDate, string3, string42, d5);
    }
}

