/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.common.AbstractSensors;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.GlobalConfig;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.SysPath;

@ThreadSafe
final class LinuxSensors
extends AbstractSensors {
    public static final String OSHI_THERMAL_ZONE_TYPE_PRIORITY = "oshi.os.linux.sensors.cpuTemperature.types";
    private static final List<String> THERMAL_ZONE_TYPE_PRIORITY = Stream.of(GlobalConfig.get("oshi.os.linux.sensors.cpuTemperature.types", "").split(",")).filter(string -> !string.isEmpty()).collect(Collectors.toList());
    private static final String TYPE = "type";
    private static final String TEMP = "temp";
    private static final String FAN = "fan";
    private static final String VOLTAGE = "in";
    private static final String[] SENSORS = new String[]{"temp", "fan", "in"};
    private static final String HWMON = "hwmon";
    private static final String HWMON_PATH = SysPath.HWMON + "hwmon";
    private static final String THERMAL_ZONE = "thermal_zone";
    private static final String THERMAL_ZONE_PATH = SysPath.THERMAL + "thermal_zone";
    private static final boolean IS_PI = LinuxSensors.queryCpuTemperatureFromVcGenCmd() > 0.0;
    private final Map<String, String> sensorsMap = new HashMap<String, String>();

    LinuxSensors() {
        if (!IS_PI) {
            this.populateSensorsMapFromHwmon();
            if (!this.sensorsMap.containsKey(TEMP)) {
                this.populateSensorsMapFromThermalZone();
            }
        }
    }

    private void populateSensorsMapFromHwmon() {
        String[] stringArray = SENSORS;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = string = stringArray[i];
            this.getSensorFilesFromPath(HWMON_PATH, string, file -> {
                try {
                    return file.getName().startsWith(string2) && file.getName().endsWith("_input") && FileUtil.getIntFromFile(file.getCanonicalPath()) > 0;
                }
                catch (IOException iOException) {
                    return false;
                }
            });
        }
    }

    private void populateSensorsMapFromThermalZone() {
        this.getSensorFilesFromPath(THERMAL_ZONE_PATH, TEMP, file -> file.getName().equals(TYPE) || file.getName().equals(TEMP), fileArray -> Stream.of(fileArray).filter(file -> TYPE.equals(file.getName())).findFirst().map(File::getPath).map(FileUtil::getStringFromFile).map(THERMAL_ZONE_TYPE_PRIORITY::indexOf).filter(n -> n >= 0).orElse(THERMAL_ZONE_TYPE_PRIORITY.size()));
    }

    private void getSensorFilesFromPath(String string, String string2, FileFilter fileFilter) {
        this.getSensorFilesFromPath(string, string2, fileFilter, fileArray -> 0);
    }

    private void getSensorFilesFromPath(String string, String string2, FileFilter fileFilter, ToIntFunction<File[]> toIntFunction) {
        String string3 = null;
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        while (Paths.get(string + n2, new String[0]).toFile().isDirectory()) {
            int n3;
            String string4 = string + n2;
            File file = new File(string4);
            File[] fileArray = file.listFiles(fileFilter);
            if (fileArray != null && fileArray.length > 0 && (n3 = toIntFunction.applyAsInt(fileArray)) < n) {
                n = n3;
                string3 = string4;
            }
            ++n2;
        }
        if (string3 != null) {
            this.sensorsMap.put(string2, String.format(Locale.ROOT, "%s/%s", string3, string2));
        }
    }

    @Override
    public double queryCpuTemperature() {
        if (IS_PI) {
            return LinuxSensors.queryCpuTemperatureFromVcGenCmd();
        }
        String string = this.sensorsMap.get(TEMP);
        if (string != null) {
            long l = 0L;
            if (string.contains(HWMON)) {
                l = FileUtil.getLongFromFile(String.format(Locale.ROOT, "%s1_input", string));
                if (l > 0L) {
                    return (double)l / 1000.0;
                }
                long l2 = 0L;
                int n = 0;
                for (int i = 2; i <= 6; ++i) {
                    l = FileUtil.getLongFromFile(String.format(Locale.ROOT, "%s%d_input", string, i));
                    if (l <= 0L) continue;
                    l2 += l;
                    ++n;
                }
                if (n > 0) {
                    return (double)l2 / ((double)n * 1000.0);
                }
            } else if (string.contains(THERMAL_ZONE) && (l = FileUtil.getLongFromFile(string)) > 0L) {
                return (double)l / 1000.0;
            }
        }
        return 0.0;
    }

    private static double queryCpuTemperatureFromVcGenCmd() {
        String string = ExecutingCommand.getFirstAnswer("vcgencmd measure_temp");
        if (string.startsWith("temp=")) {
            return ParseUtil.parseDoubleOrDefault(string.replaceAll("[^\\d|\\.]+", ""), 0.0);
        }
        return 0.0;
    }

    @Override
    public int[] queryFanSpeeds() {
        String string;
        if (!IS_PI && (string = this.sensorsMap.get(FAN)) != null) {
            Object object;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n = 1;
            while (new File((String)(object = String.format(Locale.ROOT, "%s%d_input", string, n))).exists()) {
                arrayList.add(FileUtil.getIntFromFile((String)object));
                ++n;
            }
            object = new int[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                object[i] = (Integer)arrayList.get(i);
            }
            return object;
        }
        return new int[0];
    }

    @Override
    public double queryCpuVoltage() {
        if (IS_PI) {
            return LinuxSensors.queryCpuVoltageFromVcGenCmd();
        }
        String string = this.sensorsMap.get(VOLTAGE);
        if (string != null) {
            return (double)FileUtil.getIntFromFile(String.format(Locale.ROOT, "%s1_input", string)) / 1000.0;
        }
        return 0.0;
    }

    private static double queryCpuVoltageFromVcGenCmd() {
        String string = ExecutingCommand.getFirstAnswer("vcgencmd measure_volts core");
        if (string.startsWith("volt=")) {
            return ParseUtil.parseDoubleOrDefault(string.replaceAll("[^\\d|\\.]+", ""), 0.0);
        }
        return 0.0;
    }
}

