/*
 * Decompiled with CFR 0.152.
 */
package de.jcm.discordgamesdk;

import de.jcm.discordgamesdk.Core;
import de.jcm.discordgamesdk.GameSDKException;
import de.jcm.discordgamesdk.Result;
import de.jcm.discordgamesdk.activity.ActivityType;
import de.jcm.discordgamesdk.impl.Command;
import de.jcm.discordgamesdk.impl.DataProxies;
import de.jcm.discordgamesdk.impl.commands.GetRelationships;
import de.jcm.discordgamesdk.user.OnlineStatus;
import de.jcm.discordgamesdk.user.Relationship;
import de.jcm.discordgamesdk.user.RelationshipType;
import java.util.List;
import java.util.function.Predicate;

public class RelationshipManager {
    public static final Predicate<Relationship> NO_FILTER = relationship -> true;
    public static final Predicate<Relationship> FRIEND_FILTER = relationship -> relationship.getType() == RelationshipType.FRIEND;
    public static final Predicate<Relationship> ONLINE_FILTER = relationship -> relationship.getPresence().getStatus() == OnlineStatus.ONLINE;
    public static final Predicate<Relationship> OFFLINE_FILTER = relationship -> relationship.getPresence().getStatus() == OnlineStatus.OFFLINE;
    public static final Predicate<Relationship> SPECIAL_FILTER = relationship -> relationship.getPresence().getActivity().getType() != ActivityType.PLAYING || relationship.getPresence().getActivity().getApplicationId() != 0L;
    private final Core.CorePrivate core;
    private List<Relationship> relationships;

    RelationshipManager(Core.CorePrivate corePrivate) {
        this.core = corePrivate;
        this.core.sendCommand(Command.Type.GET_RELATIONSHIPS, new Object(), command -> {
            if (command.isError()) {
                return;
            }
            GetRelationships.Response response = corePrivate.getGson().fromJson(command.getData(), GetRelationships.Response.class);
            for (DataProxies.RelationshipImpl relationshipImpl : response.getRelationships()) {
                corePrivate.relationships.put(relationshipImpl.user.getUserId(), relationshipImpl.toRelationship());
            }
            corePrivate.getEventAdapter().onRelationshipRefresh();
        });
    }

    public Relationship getWith(long l) {
        if (!this.core.relationships.containsKey(l)) {
            throw new GameSDKException(Result.NOT_FOUND);
        }
        return this.core.relationships.get(l);
    }

    public void filter(Predicate<Relationship> predicate) {
        this.relationships = this.core.relationships.values().stream().filter(predicate).toList();
    }

    public int count() {
        return this.relationships.size();
    }

    public Relationship getAt(int n) {
        return this.relationships.get(n);
    }

    public List<Relationship> asList() {
        return this.relationships;
    }
}

