/*
 * Decompiled with CFR 0.152.
 */
package de.jcm.discordgamesdk;

import de.jcm.discordgamesdk.Core;
import de.jcm.discordgamesdk.Result;
import de.jcm.discordgamesdk.impl.Command;
import de.jcm.discordgamesdk.impl.commands.Authenticate;
import de.jcm.discordgamesdk.user.DiscordUser;
import java.util.Date;
import java.util.Set;
import java.util.function.BiConsumer;

public class ApplicationManager {
    private final Core.CorePrivate core;

    ApplicationManager(Core.CorePrivate corePrivate) {
        this.core = corePrivate;
    }

    public void getOAuth2Token(BiConsumer<Result, DiscordOAuth2Token> biConsumer) {
        this.core.sendCommand(Command.Type.AUTHENTICATE, new Object(), command -> {
            Result result = this.core.checkError((Command)command);
            if (result != Result.OK) {
                biConsumer.accept(result, null);
                return;
            }
            Authenticate.Response response = this.core.getGson().fromJson(command.getData(), Authenticate.Response.class);
            biConsumer.accept(result, response.toDiscordOAuth2Token());
        });
    }

    public void authenticate(BiConsumer<Result, AuthenticationData> biConsumer) {
        this.core.sendCommand(Command.Type.AUTHENTICATE, new Object(), command -> {
            Result result = this.core.checkError((Command)command);
            if (result != Result.OK) {
                biConsumer.accept(result, null);
                return;
            }
            Authenticate.Response response = this.core.getGson().fromJson(command.getData(), Authenticate.Response.class);
            DiscordOAuth2Token discordOAuth2Token = response.toDiscordOAuth2Token();
            DiscordUser discordUser = response.user;
            Application application = response.application.toApplication();
            biConsumer.accept(result, new AuthenticationData(discordOAuth2Token, application, discordUser));
        });
    }

    public record DiscordOAuth2Token(String accessToken, Set<String> scopes, Date expires) {
    }

    public record Application(long id, String name, String icon, String description, String type, String coverImage, String summary, boolean monetized, boolean verified, String verifyKey, int flags, boolean hook, boolean storefrontAvailable) {
    }

    public record AuthenticationData(DiscordOAuth2Token token, Application application, DiscordUser user) {
    }
}

