/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.internal.$Gson$Types;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;

final class $Gson$Types$ParameterizedTypeImpl
implements Serializable,
ParameterizedType {
    private final Type ownerType;
    private final Type rawType;
    private final Type[] typeArguments;
    private static final long serialVersionUID = 0L;

    public $Gson$Types$ParameterizedTypeImpl(Type type, Class<?> clazz, Type ... typeArray) {
        Objects.requireNonNull(clazz);
        if (type == null && $Gson$Types.requiresOwnerType(clazz)) {
            throw new IllegalArgumentException("Must specify owner type for " + clazz);
        }
        this.ownerType = type == null ? null : $Gson$Types.canonicalize(type);
        this.rawType = $Gson$Types.canonicalize(clazz);
        this.typeArguments = (Type[])typeArray.clone();
        int n = this.typeArguments.length;
        for (int i = 0; i < n; ++i) {
            Objects.requireNonNull(this.typeArguments[i]);
            $Gson$Types.checkNotPrimitive(this.typeArguments[i]);
            this.typeArguments[i] = $Gson$Types.canonicalize(this.typeArguments[i]);
        }
    }

    @Override
    public Type[] getActualTypeArguments() {
        return (Type[])this.typeArguments.clone();
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    @Override
    public Type getOwnerType() {
        return this.ownerType;
    }

    public boolean equals(Object object) {
        return object instanceof ParameterizedType && $Gson$Types.equals(this, (ParameterizedType)object);
    }

    private static int hashCodeOrZero(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    public int hashCode() {
        return Arrays.hashCode(this.typeArguments) ^ this.rawType.hashCode() ^ $Gson$Types$ParameterizedTypeImpl.hashCodeOrZero(this.ownerType);
    }

    public String toString() {
        int n = this.typeArguments.length;
        if (n == 0) {
            return $Gson$Types.typeToString(this.rawType);
        }
        StringBuilder stringBuilder = new StringBuilder(30 * (n + 1));
        stringBuilder.append($Gson$Types.typeToString(this.rawType)).append("<").append($Gson$Types.typeToString(this.typeArguments[0]));
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(", ").append($Gson$Types.typeToString(this.typeArguments[i]));
        }
        return stringBuilder.append(">").toString();
    }
}

